// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// The stream ID.
	//
	// StreamId is a required field
	StreamId *string `location:"uri" locationName:"streamId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStreamInput"}

	if s.StreamId == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamId"))
	}
	if s.StreamId != nil && len(*s.StreamId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.StreamId != nil {
		v := *s.StreamId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "streamId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes a stream.
//
//    // Example sending a request using DeleteStreamRequest.
//    req := client.DeleteStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteStreamRequest(input *DeleteStreamInput) DeleteStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/streams/{streamId}",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteStreamOutput{})
	return DeleteStreamRequest{Request: req, Input: input, Copy: c.DeleteStreamRequest}
}

// DeleteStreamRequest is the request type for the
// DeleteStream API operation.
type DeleteStreamRequest struct {
	*aws.Request
	Input *DeleteStreamInput
	Copy  func(*DeleteStreamInput) DeleteStreamRequest
}

// Send marshals and sends the DeleteStream API request.
func (r DeleteStreamRequest) Send(ctx context.Context) (*DeleteStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStreamResponse{
		DeleteStreamOutput: r.Request.Data.(*DeleteStreamOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStreamResponse is the response type for the
// DeleteStream API operation.
type DeleteStreamResponse struct {
	*DeleteStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStream request.
func (r *DeleteStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
