// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateThingGroupsForThingInput struct {
	_ struct{} `type:"structure"`

	// Override dynamic thing groups with static thing groups when 10-group limit
	// is reached. If a thing belongs to 10 thing groups, and one or more of those
	// groups are dynamic thing groups, adding a thing to a static group removes
	// the thing from the last dynamic group.
	OverrideDynamicGroups *bool `locationName:"overrideDynamicGroups" type:"boolean"`

	// The groups to which the thing will be added.
	ThingGroupsToAdd []string `locationName:"thingGroupsToAdd" type:"list"`

	// The groups from which the thing will be removed.
	ThingGroupsToRemove []string `locationName:"thingGroupsToRemove" type:"list"`

	// The thing whose group memberships will be updated.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateThingGroupsForThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThingGroupsForThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateThingGroupsForThingInput"}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateThingGroupsForThingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.OverrideDynamicGroups != nil {
		v := *s.OverrideDynamicGroups

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "overrideDynamicGroups", protocol.BoolValue(v), metadata)
	}
	if len(s.ThingGroupsToAdd) > 0 {
		v := s.ThingGroupsToAdd

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingGroupsToAdd", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.ThingGroupsToRemove) > 0 {
		v := s.ThingGroupsToRemove

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingGroupsToRemove", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateThingGroupsForThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateThingGroupsForThingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateThingGroupsForThingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateThingGroupsForThing = "UpdateThingGroupsForThing"

// UpdateThingGroupsForThingRequest returns a request value for making API operation for
// AWS IoT.
//
// Updates the groups to which the thing belongs.
//
//    // Example sending a request using UpdateThingGroupsForThingRequest.
//    req := client.UpdateThingGroupsForThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) UpdateThingGroupsForThingRequest(input *UpdateThingGroupsForThingInput) UpdateThingGroupsForThingRequest {
	op := &aws.Operation{
		Name:       opUpdateThingGroupsForThing,
		HTTPMethod: "PUT",
		HTTPPath:   "/thing-groups/updateThingGroupsForThing",
	}

	if input == nil {
		input = &UpdateThingGroupsForThingInput{}
	}

	req := c.newRequest(op, input, &UpdateThingGroupsForThingOutput{})
	return UpdateThingGroupsForThingRequest{Request: req, Input: input, Copy: c.UpdateThingGroupsForThingRequest}
}

// UpdateThingGroupsForThingRequest is the request type for the
// UpdateThingGroupsForThing API operation.
type UpdateThingGroupsForThingRequest struct {
	*aws.Request
	Input *UpdateThingGroupsForThingInput
	Copy  func(*UpdateThingGroupsForThingInput) UpdateThingGroupsForThingRequest
}

// Send marshals and sends the UpdateThingGroupsForThing API request.
func (r UpdateThingGroupsForThingRequest) Send(ctx context.Context) (*UpdateThingGroupsForThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateThingGroupsForThingResponse{
		UpdateThingGroupsForThingOutput: r.Request.Data.(*UpdateThingGroupsForThingOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateThingGroupsForThingResponse is the response type for the
// UpdateThingGroupsForThing API operation.
type UpdateThingGroupsForThingResponse struct {
	*UpdateThingGroupsForThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateThingGroupsForThing request.
func (r *UpdateThingGroupsForThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
