// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastoreRequest
type DeleteDatastoreInput struct {
	_ struct{} `type:"structure"`

	// The name of the data store to delete.
	//
	// DatastoreName is a required field
	DatastoreName *string `location:"uri" locationName:"datastoreName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatastoreInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDatastoreInput"}

	if s.DatastoreName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatastoreName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDatastoreInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DatastoreName != nil {
		v := *s.DatastoreName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "datastoreName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastoreOutput
type DeleteDatastoreOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDatastoreOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDatastore = "DeleteDatastore"

// DeleteDatastoreRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Deletes the specified data store.
//
//    // Example sending a request using DeleteDatastoreRequest.
//    req := client.DeleteDatastoreRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeleteDatastore
func (c *Client) DeleteDatastoreRequest(input *DeleteDatastoreInput) DeleteDatastoreRequest {
	op := &aws.Operation{
		Name:       opDeleteDatastore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datastores/{datastoreName}",
	}

	if input == nil {
		input = &DeleteDatastoreInput{}
	}

	req := c.newRequest(op, input, &DeleteDatastoreOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteDatastoreRequest{Request: req, Input: input, Copy: c.DeleteDatastoreRequest}
}

// DeleteDatastoreRequest is the request type for the
// DeleteDatastore API operation.
type DeleteDatastoreRequest struct {
	*aws.Request
	Input *DeleteDatastoreInput
	Copy  func(*DeleteDatastoreInput) DeleteDatastoreRequest
}

// Send marshals and sends the DeleteDatastore API request.
func (r DeleteDatastoreRequest) Send(ctx context.Context) (*DeleteDatastoreResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDatastoreResponse{
		DeleteDatastoreOutput: r.Request.Data.(*DeleteDatastoreOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDatastoreResponse is the response type for the
// DeleteDatastore API operation.
type DeleteDatastoreResponse struct {
	*DeleteDatastoreOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDatastore request.
func (r *DeleteDatastoreResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
