// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfigurationRequest
type DeleteApplicationInputProcessingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The application version. You can use the DescribeApplication operation to
	// get the current application version. If the version specified is not the
	// current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the input configuration from which to delete the input processing
	// configuration. You can get a list of the input IDs for an application by
	// using the DescribeApplication operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInputProcessingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInputProcessingConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApplicationInputProcessingConfigurationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if s.InputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfigurationResponse
type DeleteApplicationInputProcessingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// The current application version ID.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DeleteApplicationInputProcessingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteApplicationInputProcessingConfiguration = "DeleteApplicationInputProcessingConfiguration"

// DeleteApplicationInputProcessingConfigurationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Deletes an InputProcessingConfiguration from an input.
//
//    // Example sending a request using DeleteApplicationInputProcessingConfigurationRequest.
//    req := client.DeleteApplicationInputProcessingConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration
func (c *Client) DeleteApplicationInputProcessingConfigurationRequest(input *DeleteApplicationInputProcessingConfigurationInput) DeleteApplicationInputProcessingConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteApplicationInputProcessingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInputProcessingConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteApplicationInputProcessingConfigurationOutput{})
	return DeleteApplicationInputProcessingConfigurationRequest{Request: req, Input: input, Copy: c.DeleteApplicationInputProcessingConfigurationRequest}
}

// DeleteApplicationInputProcessingConfigurationRequest is the request type for the
// DeleteApplicationInputProcessingConfiguration API operation.
type DeleteApplicationInputProcessingConfigurationRequest struct {
	*aws.Request
	Input *DeleteApplicationInputProcessingConfigurationInput
	Copy  func(*DeleteApplicationInputProcessingConfigurationInput) DeleteApplicationInputProcessingConfigurationRequest
}

// Send marshals and sends the DeleteApplicationInputProcessingConfiguration API request.
func (r DeleteApplicationInputProcessingConfigurationRequest) Send(ctx context.Context) (*DeleteApplicationInputProcessingConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApplicationInputProcessingConfigurationResponse{
		DeleteApplicationInputProcessingConfigurationOutput: r.Request.Data.(*DeleteApplicationInputProcessingConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApplicationInputProcessingConfigurationResponse is the response type for the
// DeleteApplicationInputProcessingConfiguration API operation.
type DeleteApplicationInputProcessingConfigurationResponse struct {
	*DeleteApplicationInputProcessingConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApplicationInputProcessingConfiguration request.
func (r *DeleteApplicationInputProcessingConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
