// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseRequest
type GetRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database that you are looking up.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRelationalDatabaseInput"}

	if s.RelationalDatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseResult
type GetRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the specified database.
	RelationalDatabase *RelationalDatabase `locationName:"relationalDatabase" type:"structure"`
}

// String returns the string representation
func (s GetRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRelationalDatabase = "GetRelationalDatabase"

// GetRelationalDatabaseRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific database in Amazon Lightsail.
//
//    // Example sending a request using GetRelationalDatabaseRequest.
//    req := client.GetRelationalDatabaseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase
func (c *Client) GetRelationalDatabaseRequest(input *GetRelationalDatabaseInput) GetRelationalDatabaseRequest {
	op := &aws.Operation{
		Name:       opGetRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseInput{}
	}

	req := c.newRequest(op, input, &GetRelationalDatabaseOutput{})
	return GetRelationalDatabaseRequest{Request: req, Input: input, Copy: c.GetRelationalDatabaseRequest}
}

// GetRelationalDatabaseRequest is the request type for the
// GetRelationalDatabase API operation.
type GetRelationalDatabaseRequest struct {
	*aws.Request
	Input *GetRelationalDatabaseInput
	Copy  func(*GetRelationalDatabaseInput) GetRelationalDatabaseRequest
}

// Send marshals and sends the GetRelationalDatabase API request.
func (r GetRelationalDatabaseRequest) Send(ctx context.Context) (*GetRelationalDatabaseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRelationalDatabaseResponse{
		GetRelationalDatabaseOutput: r.Request.Data.(*GetRelationalDatabaseOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRelationalDatabaseResponse is the response type for the
// GetRelationalDatabase API operation.
type GetRelationalDatabaseResponse struct {
	*GetRelationalDatabaseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRelationalDatabase request.
func (r *GetRelationalDatabaseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
