// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackagevod

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAssetRequest
type DescribeAssetInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAssetInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAssetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAssetResponse
type DescribeAssetOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	EgressEndpoints []EgressEndpoint `locationName:"egressEndpoints" type:"list"`

	Id *string `locationName:"id" type:"string"`

	PackagingGroupId *string `locationName:"packagingGroupId" type:"string"`

	ResourceId *string `locationName:"resourceId" type:"string"`

	SourceArn *string `locationName:"sourceArn" type:"string"`

	SourceRoleArn *string `locationName:"sourceRoleArn" type:"string"`
}

// String returns the string representation
func (s DescribeAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeAssetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EgressEndpoints) > 0 {
		v := s.EgressEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "egressEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackagingGroupId != nil {
		v := *s.PackagingGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "packagingGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceArn != nil {
		v := *s.SourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceRoleArn != nil {
		v := *s.SourceRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeAsset = "DescribeAsset"

// DescribeAssetRequest returns a request value for making API operation for
// AWS Elemental MediaPackage VOD.
//
// Returns a description of a MediaPackage VOD Asset resource.
//
//    // Example sending a request using DescribeAssetRequest.
//    req := client.DescribeAssetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/DescribeAsset
func (c *Client) DescribeAssetRequest(input *DescribeAssetInput) DescribeAssetRequest {
	op := &aws.Operation{
		Name:       opDescribeAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/assets/{id}",
	}

	if input == nil {
		input = &DescribeAssetInput{}
	}

	req := c.newRequest(op, input, &DescribeAssetOutput{})
	return DescribeAssetRequest{Request: req, Input: input, Copy: c.DescribeAssetRequest}
}

// DescribeAssetRequest is the request type for the
// DescribeAsset API operation.
type DescribeAssetRequest struct {
	*aws.Request
	Input *DescribeAssetInput
	Copy  func(*DescribeAssetInput) DescribeAssetRequest
}

// Send marshals and sends the DescribeAsset API request.
func (r DescribeAssetRequest) Send(ctx context.Context) (*DescribeAssetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAssetResponse{
		DescribeAssetOutput: r.Request.Data.(*DescribeAssetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAssetResponse is the response type for the
// DescribeAsset API operation.
type DescribeAssetResponse struct {
	*DescribeAssetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAsset request.
func (r *DescribeAssetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
