// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocksRequest
type ListWorkerBlocksInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorkerBlocksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkerBlocksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListWorkerBlocksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocksResponse
type ListWorkerBlocksOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of assignments on the page in the filtered results list, equivalent
	// to the number of assignments returned by this call.
	NumResults *int64 `type:"integer"`

	// The list of WorkerBlocks, containing the collection of Worker IDs and reasons
	// for blocking.
	WorkerBlocks []WorkerBlock `type:"list"`
}

// String returns the string representation
func (s ListWorkerBlocksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListWorkerBlocks = "ListWorkerBlocks"

// ListWorkerBlocksRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ListWorkersBlocks operation retrieves a list of Workers who are blocked
// from working on your HITs.
//
//    // Example sending a request using ListWorkerBlocksRequest.
//    req := client.ListWorkerBlocksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks
func (c *Client) ListWorkerBlocksRequest(input *ListWorkerBlocksInput) ListWorkerBlocksRequest {
	op := &aws.Operation{
		Name:       opListWorkerBlocks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkerBlocksInput{}
	}

	req := c.newRequest(op, input, &ListWorkerBlocksOutput{})
	return ListWorkerBlocksRequest{Request: req, Input: input, Copy: c.ListWorkerBlocksRequest}
}

// ListWorkerBlocksRequest is the request type for the
// ListWorkerBlocks API operation.
type ListWorkerBlocksRequest struct {
	*aws.Request
	Input *ListWorkerBlocksInput
	Copy  func(*ListWorkerBlocksInput) ListWorkerBlocksRequest
}

// Send marshals and sends the ListWorkerBlocks API request.
func (r ListWorkerBlocksRequest) Send(ctx context.Context) (*ListWorkerBlocksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListWorkerBlocksResponse{
		ListWorkerBlocksOutput: r.Request.Data.(*ListWorkerBlocksOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListWorkerBlocksRequestPaginator returns a paginator for ListWorkerBlocks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListWorkerBlocksRequest(input)
//   p := mturk.NewListWorkerBlocksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListWorkerBlocksPaginator(req ListWorkerBlocksRequest) ListWorkerBlocksPaginator {
	return ListWorkerBlocksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListWorkerBlocksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListWorkerBlocksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListWorkerBlocksPaginator struct {
	aws.Pager
}

func (p *ListWorkerBlocksPaginator) CurrentPage() *ListWorkerBlocksOutput {
	return p.Pager.CurrentPage().(*ListWorkerBlocksOutput)
}

// ListWorkerBlocksResponse is the response type for the
// ListWorkerBlocks API operation.
type ListWorkerBlocksResponse struct {
	*ListWorkerBlocksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListWorkerBlocks request.
func (r *ListWorkerBlocksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
