// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClustersRequest
type DescribeEcsClustersInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs, one for each cluster to be described.
	EcsClusterArns []string `type:"list"`

	// To receive a paginated response, use this parameter to specify the maximum
	// number of results to be returned with a single call. If the number of available
	// results exceeds this maximum, the response includes a NextToken value that
	// you can assign to the NextToken request parameter to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object'sNextToken parameter value is set to a token. To retrieve
	// the next set of results, call DescribeEcsClusters again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `type:"string"`

	// A stack ID. DescribeEcsClusters returns a description of the cluster that
	// is registered with the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeEcsClustersInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeEcsClusters request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClustersResult
type DescribeEcsClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of EcsCluster objects containing the cluster descriptions.
	EcsClusters []EcsCluster `type:"list"`

	// If a paginated request does not return all of the remaining results, this
	// parameter is set to a token that you can assign to the request object's NextToken
	// parameter to retrieve the next set of results. If the previous paginated
	// request returned all of the remaining results, this parameter is set to null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEcsClustersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEcsClusters = "DescribeEcsClusters"

// DescribeEcsClustersRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Describes Amazon ECS clusters that are registered with a stack. If you specify
// only a stack ID, you can use the MaxResults and NextToken parameters to paginate
// the response. However, AWS OpsWorks Stacks currently supports only one cluster
// per layer, so the result set has a maximum of one element.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack or an attached policy that explicitly
// grants permission. For more information about user permissions, see Managing
// User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// This call accepts only one resource-identifying parameter.
//
//    // Example sending a request using DescribeEcsClustersRequest.
//    req := client.DescribeEcsClustersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClusters
func (c *Client) DescribeEcsClustersRequest(input *DescribeEcsClustersInput) DescribeEcsClustersRequest {
	op := &aws.Operation{
		Name:       opDescribeEcsClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEcsClustersInput{}
	}

	req := c.newRequest(op, input, &DescribeEcsClustersOutput{})
	return DescribeEcsClustersRequest{Request: req, Input: input, Copy: c.DescribeEcsClustersRequest}
}

// DescribeEcsClustersRequest is the request type for the
// DescribeEcsClusters API operation.
type DescribeEcsClustersRequest struct {
	*aws.Request
	Input *DescribeEcsClustersInput
	Copy  func(*DescribeEcsClustersInput) DescribeEcsClustersRequest
}

// Send marshals and sends the DescribeEcsClusters API request.
func (r DescribeEcsClustersRequest) Send(ctx context.Context) (*DescribeEcsClustersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEcsClustersResponse{
		DescribeEcsClustersOutput: r.Request.Data.(*DescribeEcsClustersOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeEcsClustersRequestPaginator returns a paginator for DescribeEcsClusters.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeEcsClustersRequest(input)
//   p := opsworks.NewDescribeEcsClustersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeEcsClustersPaginator(req DescribeEcsClustersRequest) DescribeEcsClustersPaginator {
	return DescribeEcsClustersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeEcsClustersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeEcsClustersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeEcsClustersPaginator struct {
	aws.Pager
}

func (p *DescribeEcsClustersPaginator) CurrentPage() *DescribeEcsClustersOutput {
	return p.Pager.CurrentPage().(*DescribeEcsClustersOutput)
}

// DescribeEcsClustersResponse is the response type for the
// DescribeEcsClusters API operation.
type DescribeEcsClustersResponse struct {
	*DescribeEcsClustersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEcsClusters request.
func (r *DescribeEcsClustersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
