// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShareRequest
type DeleteResourceShareInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource share.
	//
	// ResourceShareArn is a required field
	ResourceShareArn *string `location:"querystring" locationName:"resourceShareArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceShareInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceShareInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteResourceShareInput"}

	if s.ResourceShareArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceShareArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteResourceShareInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceShareArn != nil {
		v := *s.ResourceShareArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "resourceShareArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShareResponse
type DeleteResourceShareOutput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string"`

	// Indicates whether the request succeeded.
	ReturnValue *bool `locationName:"returnValue" type:"boolean"`
}

// String returns the string representation
func (s DeleteResourceShareOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteResourceShareOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReturnValue != nil {
		v := *s.ReturnValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "returnValue", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opDeleteResourceShare = "DeleteResourceShare"

// DeleteResourceShareRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Deletes the specified resource share.
//
//    // Example sending a request using DeleteResourceShareRequest.
//    req := client.DeleteResourceShareRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare
func (c *Client) DeleteResourceShareRequest(input *DeleteResourceShareInput) DeleteResourceShareRequest {
	op := &aws.Operation{
		Name:       opDeleteResourceShare,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deleteresourceshare",
	}

	if input == nil {
		input = &DeleteResourceShareInput{}
	}

	req := c.newRequest(op, input, &DeleteResourceShareOutput{})
	return DeleteResourceShareRequest{Request: req, Input: input, Copy: c.DeleteResourceShareRequest}
}

// DeleteResourceShareRequest is the request type for the
// DeleteResourceShare API operation.
type DeleteResourceShareRequest struct {
	*aws.Request
	Input *DeleteResourceShareInput
	Copy  func(*DeleteResourceShareInput) DeleteResourceShareRequest
}

// Send marshals and sends the DeleteResourceShare API request.
func (r DeleteResourceShareRequest) Send(ctx context.Context) (*DeleteResourceShareResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteResourceShareResponse{
		DeleteResourceShareOutput: r.Request.Data.(*DeleteResourceShareOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteResourceShareResponse is the response type for the
// DeleteResourceShare API operation.
type DeleteResourceShareResponse struct {
	*DeleteResourceShareOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteResourceShare request.
func (r *DeleteResourceShareResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
