// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DetectTextInput struct {
	_ struct{} `type:"structure"`

	// The input image as base64-encoded bytes or an Amazon S3 object. If you use
	// the AWS CLI to call Amazon Rekognition operations, you can't pass image bytes.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetectTextInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectTextInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectTextInput"}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetectTextOutput struct {
	_ struct{} `type:"structure"`

	// An array of text that was detected in the input image.
	TextDetections []TextDetection `type:"list"`
}

// String returns the string representation
func (s DetectTextOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetectText = "DetectText"

// DetectTextRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Detects text in the input image and converts it into machine-readable text.
//
// Pass the input image as base64-encoded image bytes or as a reference to an
// image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition
// operations, you must pass it as a reference to an image in an Amazon S3 bucket.
// For the AWS CLI, passing image bytes is not supported. The image must be
// either a .png or .jpeg formatted file.
//
// The DetectText operation returns text in an array of TextDetection elements,
// TextDetections. Each TextDetection element provides information about a single
// word or line of text that was detected in the image.
//
// A word is one or more ISO basic latin script characters that are not separated
// by spaces. DetectText can detect up to 50 words in an image.
//
// A line is a string of equally spaced words. A line isn't necessarily a complete
// sentence. For example, a driver's license number is detected as a line. A
// line ends when there is no aligned text after it. Also, a line ends when
// there is a large gap between words, relative to the length of the words.
// This means, depending on the gap between words, Amazon Rekognition may detect
// multiple lines in text aligned in the same direction. Periods don't represent
// the end of a line. If a sentence spans multiple lines, the DetectText operation
// returns multiple lines.
//
// To determine whether a TextDetection element is a line of text or a word,
// use the TextDetection object Type field.
//
// To be detected, text must be within +/- 90 degrees orientation of the horizontal
// axis.
//
// For more information, see DetectText in the Amazon Rekognition Developer
// Guide.
//
//    // Example sending a request using DetectTextRequest.
//    req := client.DetectTextRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetectTextRequest(input *DetectTextInput) DetectTextRequest {
	op := &aws.Operation{
		Name:       opDetectText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectTextInput{}
	}

	req := c.newRequest(op, input, &DetectTextOutput{})
	return DetectTextRequest{Request: req, Input: input, Copy: c.DetectTextRequest}
}

// DetectTextRequest is the request type for the
// DetectText API operation.
type DetectTextRequest struct {
	*aws.Request
	Input *DetectTextInput
	Copy  func(*DetectTextInput) DetectTextRequest
}

// Send marshals and sends the DetectText API request.
func (r DetectTextRequest) Send(ctx context.Context) (*DetectTextResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetectTextResponse{
		DetectTextOutput: r.Request.Data.(*DetectTextOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetectTextResponse is the response type for the
// DetectText API operation.
type DetectTextResponse struct {
	*DetectTextOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetectText request.
func (r *DetectTextResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
