// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPathsInput
type ListLaunchPathsInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLaunchPathsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLaunchPathsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLaunchPathsInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPathsOutput
type ListLaunchPathsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the launch path.
	LaunchPathSummaries []LaunchPathSummary `type:"list"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListLaunchPathsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLaunchPaths = "ListLaunchPaths"

// ListLaunchPathsRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists the paths to the specified product. A path is how the user has access
// to a specified product, and is necessary when provisioning a product. A path
// also determines the constraints put on the product.
//
//    // Example sending a request using ListLaunchPathsRequest.
//    req := client.ListLaunchPathsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths
func (c *Client) ListLaunchPathsRequest(input *ListLaunchPathsInput) ListLaunchPathsRequest {
	op := &aws.Operation{
		Name:       opListLaunchPaths,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLaunchPathsInput{}
	}

	req := c.newRequest(op, input, &ListLaunchPathsOutput{})
	return ListLaunchPathsRequest{Request: req, Input: input, Copy: c.ListLaunchPathsRequest}
}

// ListLaunchPathsRequest is the request type for the
// ListLaunchPaths API operation.
type ListLaunchPathsRequest struct {
	*aws.Request
	Input *ListLaunchPathsInput
	Copy  func(*ListLaunchPathsInput) ListLaunchPathsRequest
}

// Send marshals and sends the ListLaunchPaths API request.
func (r ListLaunchPathsRequest) Send(ctx context.Context) (*ListLaunchPathsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLaunchPathsResponse{
		ListLaunchPathsOutput: r.Request.Data.(*ListLaunchPathsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListLaunchPathsRequestPaginator returns a paginator for ListLaunchPaths.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListLaunchPathsRequest(input)
//   p := servicecatalog.NewListLaunchPathsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListLaunchPathsPaginator(req ListLaunchPathsRequest) ListLaunchPathsPaginator {
	return ListLaunchPathsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListLaunchPathsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListLaunchPathsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListLaunchPathsPaginator struct {
	aws.Pager
}

func (p *ListLaunchPathsPaginator) CurrentPage() *ListLaunchPathsOutput {
	return p.Pager.CurrentPage().(*ListLaunchPathsOutput)
}

// ListLaunchPathsResponse is the response type for the
// ListLaunchPaths API operation.
type ListLaunchPathsResponse struct {
	*ListLaunchPathsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLaunchPaths request.
func (r *ListLaunchPathsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
