// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to enable or disable Amazon SES Easy DKIM signing for
// an identity. For more information about setting up Easy DKIM, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabledRequest
type SetIdentityDkimEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether DKIM signing is enabled for an identity. Set to true to enable
	// DKIM signing for this identity; false to disable it.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// The identity for which DKIM signing should be enabled or disabled.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityDkimEnabledInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetIdentityDkimEnabledInput"}

	if s.DkimEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("DkimEnabled"))
	}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabledResponse
type SetIdentityDkimEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetIdentityDkimEnabled = "SetIdentityDkimEnabled"

// SetIdentityDkimEnabledRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Enables or disables Easy DKIM signing of email sent from an identity:
//
//    * If Easy DKIM signing is enabled for a domain name identity (such as
//    example.com), then Amazon SES will DKIM-sign all email sent by addresses
//    under that domain name (for example, user@example.com).
//
//    * If Easy DKIM signing is enabled for an email address, then Amazon SES
//    will DKIM-sign all email sent by that email address.
//
// For email addresses (for example, user@example.com), you can only enable
// Easy DKIM signing if the corresponding domain (in this case, example.com)
// has been set up for Easy DKIM using the AWS Console or the VerifyDomainDkim
// operation.
//
// You can execute this operation no more than once per second.
//
// For more information about Easy DKIM signing, go to the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
//
//    // Example sending a request using SetIdentityDkimEnabledRequest.
//    req := client.SetIdentityDkimEnabledRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled
func (c *Client) SetIdentityDkimEnabledRequest(input *SetIdentityDkimEnabledInput) SetIdentityDkimEnabledRequest {
	op := &aws.Operation{
		Name:       opSetIdentityDkimEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityDkimEnabledInput{}
	}

	req := c.newRequest(op, input, &SetIdentityDkimEnabledOutput{})
	return SetIdentityDkimEnabledRequest{Request: req, Input: input, Copy: c.SetIdentityDkimEnabledRequest}
}

// SetIdentityDkimEnabledRequest is the request type for the
// SetIdentityDkimEnabled API operation.
type SetIdentityDkimEnabledRequest struct {
	*aws.Request
	Input *SetIdentityDkimEnabledInput
	Copy  func(*SetIdentityDkimEnabledInput) SetIdentityDkimEnabledRequest
}

// Send marshals and sends the SetIdentityDkimEnabled API request.
func (r SetIdentityDkimEnabledRequest) Send(ctx context.Context) (*SetIdentityDkimEnabledResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetIdentityDkimEnabledResponse{
		SetIdentityDkimEnabledOutput: r.Request.Data.(*SetIdentityDkimEnabledOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetIdentityDkimEnabledResponse is the response type for the
// SetIdentityDkimEnabled API operation.
type SetIdentityDkimEnabledResponse struct {
	*SetIdentityDkimEnabledOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetIdentityDkimEnabled request.
func (r *SetIdentityDkimEnabledResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
