// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input for ListEndpointsByPlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplicationInput
type ListEndpointsByPlatformApplicationInput struct {
	_ struct{} `type:"structure"`

	// NextToken string is used when calling ListEndpointsByPlatformApplication
	// action to retrieve additional records that are available after the first
	// page results.
	NextToken *string `type:"string"`

	// PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsByPlatformApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListEndpointsByPlatformApplicationInput"}

	if s.PlatformApplicationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PlatformApplicationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response for ListEndpointsByPlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplicationResponse
type ListEndpointsByPlatformApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Endpoints returned for ListEndpointsByPlatformApplication action.
	Endpoints []Endpoint `type:"list"`

	// NextToken string is returned when calling ListEndpointsByPlatformApplication
	// action if additional records are available after the first page results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opListEndpointsByPlatformApplication = "ListEndpointsByPlatformApplication"

// ListEndpointsByPlatformApplicationRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Lists the endpoints and endpoint attributes for devices in a supported push
// notification service, such as GCM and APNS. The results for ListEndpointsByPlatformApplication
// are paginated and return a limited list of endpoints, up to 100. If additional
// records are available after the first page results, then a NextToken string
// will be returned. To receive the next page, you call ListEndpointsByPlatformApplication
// again using the NextToken string received from the previous call. When there
// are no more records to return, NextToken will be null. For more information,
// see Using Amazon SNS Mobile Push Notifications (https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// This action is throttled at 30 transactions per second (TPS).
//
//    // Example sending a request using ListEndpointsByPlatformApplicationRequest.
//    req := client.ListEndpointsByPlatformApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication
func (c *Client) ListEndpointsByPlatformApplicationRequest(input *ListEndpointsByPlatformApplicationInput) ListEndpointsByPlatformApplicationRequest {
	op := &aws.Operation{
		Name:       opListEndpointsByPlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsByPlatformApplicationInput{}
	}

	req := c.newRequest(op, input, &ListEndpointsByPlatformApplicationOutput{})
	return ListEndpointsByPlatformApplicationRequest{Request: req, Input: input, Copy: c.ListEndpointsByPlatformApplicationRequest}
}

// ListEndpointsByPlatformApplicationRequest is the request type for the
// ListEndpointsByPlatformApplication API operation.
type ListEndpointsByPlatformApplicationRequest struct {
	*aws.Request
	Input *ListEndpointsByPlatformApplicationInput
	Copy  func(*ListEndpointsByPlatformApplicationInput) ListEndpointsByPlatformApplicationRequest
}

// Send marshals and sends the ListEndpointsByPlatformApplication API request.
func (r ListEndpointsByPlatformApplicationRequest) Send(ctx context.Context) (*ListEndpointsByPlatformApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEndpointsByPlatformApplicationResponse{
		ListEndpointsByPlatformApplicationOutput: r.Request.Data.(*ListEndpointsByPlatformApplicationOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListEndpointsByPlatformApplicationRequestPaginator returns a paginator for ListEndpointsByPlatformApplication.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListEndpointsByPlatformApplicationRequest(input)
//   p := sns.NewListEndpointsByPlatformApplicationRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListEndpointsByPlatformApplicationPaginator(req ListEndpointsByPlatformApplicationRequest) ListEndpointsByPlatformApplicationPaginator {
	return ListEndpointsByPlatformApplicationPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListEndpointsByPlatformApplicationInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListEndpointsByPlatformApplicationPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEndpointsByPlatformApplicationPaginator struct {
	aws.Pager
}

func (p *ListEndpointsByPlatformApplicationPaginator) CurrentPage() *ListEndpointsByPlatformApplicationOutput {
	return p.Pager.CurrentPage().(*ListEndpointsByPlatformApplicationOutput)
}

// ListEndpointsByPlatformApplicationResponse is the response type for the
// ListEndpointsByPlatformApplication API operation.
type ListEndpointsByPlatformApplicationResponse struct {
	*ListEndpointsByPlatformApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEndpointsByPlatformApplication request.
func (r *ListEndpointsByPlatformApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
