// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Endpoint for mobile app and device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Attributes for endpoint.
	Attributes map[string]string `type:"map"`

	// EndpointArn for mobile app and device.
	EndpointArn *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For
// more information, see Publish (https://docs.aws.amazon.com/sns/latest/api/API_Publish.html).
//
// Name, type, and value must not be empty or null. In addition, the message
// body should not be empty or null. All parts of the message attribute, including
// name, type, and value, are included in the message size restriction, which
// is currently 256 KB (262,144 bytes). For more information, see Using Amazon
// SNS Message Attributes (https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/MessageAttributeValue
type MessageAttributeValue struct {
	_ struct{} `type:"structure"`

	// Binary type attributes can store any binary data, for example, compressed
	// data, encrypted data, or images.
	//
	// BinaryValue is automatically base64 encoded/decoded by the SDK.
	BinaryValue []byte `type:"blob"`

	// Amazon SNS supports the following logical data types: String, String.Array,
	// Number, and Binary. For more information, see Message Attribute Data Types
	// (https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
	//
	// DataType is a required field
	DataType *string `type:"string" required:"true"`

	// Strings are Unicode with UTF8 binary encoding. For a list of code values,
	// see ASCII Printable Characters (https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s MessageAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageAttributeValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MessageAttributeValue"}

	if s.DataType == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Platform application object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PlatformApplication
type PlatformApplication struct {
	_ struct{} `type:"structure"`

	// Attributes for platform application object.
	Attributes map[string]string `type:"map"`

	// PlatformApplicationArn for platform application object.
	PlatformApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s PlatformApplication) String() string {
	return awsutil.Prettify(s)
}

// A wrapper type for the attributes of an Amazon SNS subscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscription
type Subscription struct {
	_ struct{} `type:"structure"`

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`

	// The subscription's ARN.
	SubscriptionArn *string `type:"string"`

	// The ARN of the subscription's topic.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// The list of tags to be added to the specified topic.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The required key portion of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional value portion of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a
// topic's attributes, use GetTopicAttributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Topic
type Topic struct {
	_ struct{} `type:"structure"`

	// The topic's ARN.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s Topic) String() string {
	return awsutil.Prettify(s)
}
