// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommandRequest
type CancelCommandInput struct {
	_ struct{} `type:"structure"`

	// The ID of the command you want to cancel.
	//
	// CommandId is a required field
	CommandId *string `min:"36" type:"string" required:"true"`

	// (Optional) A list of instance IDs on which you want to cancel the command.
	// If not provided, the command is canceled on every instance on which it was
	// requested.
	InstanceIds []string `type:"list"`
}

// String returns the string representation
func (s CancelCommandInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCommandInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelCommandInput"}

	if s.CommandId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommandId"))
	}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("CommandId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Whether or not the command was successfully canceled. There is no guarantee
// that a request can be canceled.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommandResult
type CancelCommandOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCommandOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelCommand = "CancelCommand"

// CancelCommandRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Attempts to cancel the command specified by the Command ID. There is no guarantee
// that the command will be terminated and the underlying process stopped.
//
//    // Example sending a request using CancelCommandRequest.
//    req := client.CancelCommandRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand
func (c *Client) CancelCommandRequest(input *CancelCommandInput) CancelCommandRequest {
	op := &aws.Operation{
		Name:       opCancelCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCommandInput{}
	}

	req := c.newRequest(op, input, &CancelCommandOutput{})
	return CancelCommandRequest{Request: req, Input: input, Copy: c.CancelCommandRequest}
}

// CancelCommandRequest is the request type for the
// CancelCommand API operation.
type CancelCommandRequest struct {
	*aws.Request
	Input *CancelCommandInput
	Copy  func(*CancelCommandInput) CancelCommandRequest
}

// Send marshals and sends the CancelCommand API request.
func (r CancelCommandRequest) Send(ctx context.Context) (*CancelCommandResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelCommandResponse{
		CancelCommandOutput: r.Request.Data.(*CancelCommandOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelCommandResponse is the response type for the
// CancelCommand API operation.
type CancelCommandResponse struct {
	*CancelCommandOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelCommand request.
func (r *CancelCommandResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
