// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionsRequest
type DescribeMaintenanceWindowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Each entry in the array is a structure containing:
	//
	// Key (string, between 1 and 128 characters)
	//
	// Values (array of strings, each string is between 1 and 256 characters)
	//
	// The supported Keys are ExecutedBefore and ExecutedAfter with the value being
	// a date/time string such as 2016-11-04T05:00:00Z.
	Filters []MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window whose executions should be retrieved.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowExecutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMaintenanceWindowExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}

	if s.WindowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionsResult
type DescribeMaintenanceWindowExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the Maintenance Windows execution.
	WindowExecutions []MaintenanceWindowExecution `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMaintenanceWindowExecutions = "DescribeMaintenanceWindowExecutions"

// DescribeMaintenanceWindowExecutionsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Lists the executions of a Maintenance Window. This includes information about
// when the Maintenance Window was scheduled to be active, and information about
// tasks registered and run with the Maintenance Window.
//
//    // Example sending a request using DescribeMaintenanceWindowExecutionsRequest.
//    req := client.DescribeMaintenanceWindowExecutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions
func (c *Client) DescribeMaintenanceWindowExecutionsRequest(input *DescribeMaintenanceWindowExecutionsInput) DescribeMaintenanceWindowExecutionsRequest {
	op := &aws.Operation{
		Name:       opDescribeMaintenanceWindowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionsInput{}
	}

	req := c.newRequest(op, input, &DescribeMaintenanceWindowExecutionsOutput{})
	return DescribeMaintenanceWindowExecutionsRequest{Request: req, Input: input, Copy: c.DescribeMaintenanceWindowExecutionsRequest}
}

// DescribeMaintenanceWindowExecutionsRequest is the request type for the
// DescribeMaintenanceWindowExecutions API operation.
type DescribeMaintenanceWindowExecutionsRequest struct {
	*aws.Request
	Input *DescribeMaintenanceWindowExecutionsInput
	Copy  func(*DescribeMaintenanceWindowExecutionsInput) DescribeMaintenanceWindowExecutionsRequest
}

// Send marshals and sends the DescribeMaintenanceWindowExecutions API request.
func (r DescribeMaintenanceWindowExecutionsRequest) Send(ctx context.Context) (*DescribeMaintenanceWindowExecutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMaintenanceWindowExecutionsResponse{
		DescribeMaintenanceWindowExecutionsOutput: r.Request.Data.(*DescribeMaintenanceWindowExecutionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMaintenanceWindowExecutionsResponse is the response type for the
// DescribeMaintenanceWindowExecutions API operation.
type DescribeMaintenanceWindowExecutionsResponse struct {
	*DescribeMaintenanceWindowExecutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMaintenanceWindowExecutions request.
func (r *DescribeMaintenanceWindowExecutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
