// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummariesRequest
type ListResourceComplianceSummariesInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []ComplianceStringFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceComplianceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceComplianceSummariesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourceComplianceSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummariesResult
type ListResourceComplianceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// A summary count for specified or targeted managed instances. Summary count
	// includes information about compliant and non-compliant State Manager associations,
	// patch status, or custom items according to the filter criteria that you specify.
	ResourceComplianceSummaryItems []ResourceComplianceSummaryItem `type:"list"`
}

// String returns the string representation
func (s ListResourceComplianceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResourceComplianceSummaries = "ListResourceComplianceSummaries"

// ListResourceComplianceSummariesRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Returns a resource-level summary count. The summary includes information
// about compliant and non-compliant statuses and detailed compliance-item severity
// counts, according to the filter criteria you specify.
//
//    // Example sending a request using ListResourceComplianceSummariesRequest.
//    req := client.ListResourceComplianceSummariesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries
func (c *Client) ListResourceComplianceSummariesRequest(input *ListResourceComplianceSummariesInput) ListResourceComplianceSummariesRequest {
	op := &aws.Operation{
		Name:       opListResourceComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceComplianceSummariesInput{}
	}

	req := c.newRequest(op, input, &ListResourceComplianceSummariesOutput{})
	return ListResourceComplianceSummariesRequest{Request: req, Input: input, Copy: c.ListResourceComplianceSummariesRequest}
}

// ListResourceComplianceSummariesRequest is the request type for the
// ListResourceComplianceSummaries API operation.
type ListResourceComplianceSummariesRequest struct {
	*aws.Request
	Input *ListResourceComplianceSummariesInput
	Copy  func(*ListResourceComplianceSummariesInput) ListResourceComplianceSummariesRequest
}

// Send marshals and sends the ListResourceComplianceSummaries API request.
func (r ListResourceComplianceSummariesRequest) Send(ctx context.Context) (*ListResourceComplianceSummariesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceComplianceSummariesResponse{
		ListResourceComplianceSummariesOutput: r.Request.Data.(*ListResourceComplianceSummariesOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListResourceComplianceSummariesResponse is the response type for the
// ListResourceComplianceSummaries API operation.
type ListResourceComplianceSummariesResponse struct {
	*ListResourceComplianceSummariesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceComplianceSummaries request.
func (r *ListResourceComplianceSummariesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
