// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServerRequest
type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// The virtual private cloud (VPC) endpoint settings that are configured for
	// your SFTP server. With a VPC endpoint, your SFTP server isn't accessible
	// over the public internet.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of endpoint that you want your SFTP server to connect to. You can
	// choose to connect to the public internet or a virtual private cloud (VPC)
	// endpoint. With a VPC endpoint, your SFTP server isn't accessible over the
	// public internet.
	EndpointType EndpointType `type:"string" enum:"true"`

	// The RSA private key as generated by ssh-keygen -N "" -f my-new-server-key.
	//
	// If you aren't planning to migrate existing users from an existing SFTP server
	// to a new AWS SFTP server, don't update the host key. Accidentally changing
	// a server's host key can be disruptive. For more information, see change-host-key
	// in the AWS SFTP User Guide.
	HostKey *string `type:"string"`

	// This response parameter is an array containing all of the information required
	// to call a customer's authentication API method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// A value that changes the AWS Identity and Access Management (IAM) role that
	// allows Amazon S3 events to be logged in Amazon CloudWatch, turning logging
	// on or off.
	LoggingRole *string `type:"string"`

	// A system-assigned unique identifier for an SFTP server instance that the
	// user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServerInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServerResponse
type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that the user account
	// is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// Updates the server properties after that server has been created.
//
// The UpdateServer call returns the ServerId of the Secure File Transfer Protocol
// (SFTP) server you updated.
//
//    // Example sending a request using UpdateServerRequest.
//    req := client.UpdateServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Client) UpdateServerRequest(input *UpdateServerInput) UpdateServerRequest {
	op := &aws.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	req := c.newRequest(op, input, &UpdateServerOutput{})
	return UpdateServerRequest{Request: req, Input: input, Copy: c.UpdateServerRequest}
}

// UpdateServerRequest is the request type for the
// UpdateServer API operation.
type UpdateServerRequest struct {
	*aws.Request
	Input *UpdateServerInput
	Copy  func(*UpdateServerInput) UpdateServerRequest
}

// Send marshals and sends the UpdateServer API request.
func (r UpdateServerRequest) Send(ctx context.Context) (*UpdateServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServerResponse{
		UpdateServerOutput: r.Request.Data.(*UpdateServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServerResponse is the response type for the
// UpdateServer API operation.
type UpdateServerResponse struct {
	*UpdateServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServer request.
func (r *UpdateServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
