// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissionsRequest
type ListMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user, group, or resource for which to list mailbox
	// permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the organization under which the user, group, or resource
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMailboxPermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMailboxPermissionsInput"}

	if s.EntityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("EntityId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissionsResponse
type ListMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// One page of the user, group, or resource mailbox permissions.
	Permissions []Permission `type:"list"`
}

// String returns the string representation
func (s ListMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListMailboxPermissions = "ListMailboxPermissions"

// ListMailboxPermissionsRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Lists the mailbox permissions associated with a user, group, or resource
// mailbox.
//
//    // Example sending a request using ListMailboxPermissionsRequest.
//    req := client.ListMailboxPermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions
func (c *Client) ListMailboxPermissionsRequest(input *ListMailboxPermissionsInput) ListMailboxPermissionsRequest {
	op := &aws.Operation{
		Name:       opListMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMailboxPermissionsInput{}
	}

	req := c.newRequest(op, input, &ListMailboxPermissionsOutput{})
	return ListMailboxPermissionsRequest{Request: req, Input: input, Copy: c.ListMailboxPermissionsRequest}
}

// ListMailboxPermissionsRequest is the request type for the
// ListMailboxPermissions API operation.
type ListMailboxPermissionsRequest struct {
	*aws.Request
	Input *ListMailboxPermissionsInput
	Copy  func(*ListMailboxPermissionsInput) ListMailboxPermissionsRequest
}

// Send marshals and sends the ListMailboxPermissions API request.
func (r ListMailboxPermissionsRequest) Send(ctx context.Context) (*ListMailboxPermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMailboxPermissionsResponse{
		ListMailboxPermissionsOutput: r.Request.Data.(*ListMailboxPermissionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMailboxPermissionsRequestPaginator returns a paginator for ListMailboxPermissions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMailboxPermissionsRequest(input)
//   p := workmail.NewListMailboxPermissionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMailboxPermissionsPaginator(req ListMailboxPermissionsRequest) ListMailboxPermissionsPaginator {
	return ListMailboxPermissionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMailboxPermissionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMailboxPermissionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMailboxPermissionsPaginator struct {
	aws.Pager
}

func (p *ListMailboxPermissionsPaginator) CurrentPage() *ListMailboxPermissionsOutput {
	return p.Pager.CurrentPage().(*ListMailboxPermissionsOutput)
}

// ListMailboxPermissionsResponse is the response type for the
// ListMailboxPermissions API operation.
type ListMailboxPermissionsResponse struct {
	*ListMailboxPermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMailboxPermissions request.
func (r *ListMailboxPermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
