// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResourceRequest
type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's booking options to be updated.
	BookingOptions *BookingOptions `type:"structure"`

	// The name of the resource to be updated.
	Name *string `min:"1" type:"string"`

	// The identifier associated with the organization for which the resource is
	// updated.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource to be updated.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResourceResponse
type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Updates data for the resource. To have the latest information, it must be
// preceded by a DescribeResource call. The dataset in the request should be
// the one expected when performing another DescribeResource call.
//
//    // Example sending a request using UpdateResourceRequest.
//    req := client.UpdateResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource
func (c *Client) UpdateResourceRequest(input *UpdateResourceInput) UpdateResourceRequest {
	op := &aws.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	req := c.newRequest(op, input, &UpdateResourceOutput{})
	return UpdateResourceRequest{Request: req, Input: input, Copy: c.UpdateResourceRequest}
}

// UpdateResourceRequest is the request type for the
// UpdateResource API operation.
type UpdateResourceRequest struct {
	*aws.Request
	Input *UpdateResourceInput
	Copy  func(*UpdateResourceInput) UpdateResourceRequest
}

// Send marshals and sends the UpdateResource API request.
func (r UpdateResourceRequest) Send(ctx context.Context) (*UpdateResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateResourceResponse{
		UpdateResourceOutput: r.Request.Data.(*UpdateResourceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateResourceResponse is the response type for the
// UpdateResource API operation.
type UpdateResourceResponse struct {
	*UpdateResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateResource request.
func (r *UpdateResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
