package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterAccessWhiteList invokes the adb.ModifyDBClusterAccessWhiteList API synchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusteraccesswhitelist.html
func (client *Client) ModifyDBClusterAccessWhiteList(request *ModifyDBClusterAccessWhiteListRequest) (response *ModifyDBClusterAccessWhiteListResponse, err error) {
	response = CreateModifyDBClusterAccessWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterAccessWhiteListWithChan invokes the adb.ModifyDBClusterAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusteraccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBClusterAccessWhiteListWithChan(request *ModifyDBClusterAccessWhiteListRequest) (<-chan *ModifyDBClusterAccessWhiteListResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterAccessWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterAccessWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterAccessWhiteListWithCallback invokes the adb.ModifyDBClusterAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusteraccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBClusterAccessWhiteListWithCallback(request *ModifyDBClusterAccessWhiteListRequest, callback func(response *ModifyDBClusterAccessWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterAccessWhiteListResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterAccessWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterAccessWhiteListRequest is the request struct for api ModifyDBClusterAccessWhiteList
type ModifyDBClusterAccessWhiteListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityIps               string           `position:"Query" name:"SecurityIps"`
	DBClusterIPArrayAttribute string           `position:"Query" name:"DBClusterIPArrayAttribute"`
	ModifyMode                string           `position:"Query" name:"ModifyMode"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId               string           `position:"Query" name:"DBClusterId"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	DBClusterIPArrayName      string           `position:"Query" name:"DBClusterIPArrayName"`
}

// ModifyDBClusterAccessWhiteListResponse is the response struct for api ModifyDBClusterAccessWhiteList
type ModifyDBClusterAccessWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterAccessWhiteListRequest creates a request to invoke ModifyDBClusterAccessWhiteList API
func CreateModifyDBClusterAccessWhiteListRequest() (request *ModifyDBClusterAccessWhiteListRequest) {
	request = &ModifyDBClusterAccessWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "ModifyDBClusterAccessWhiteList", "ads", "openAPI")
	return
}

// CreateModifyDBClusterAccessWhiteListResponse creates a response to parse from ModifyDBClusterAccessWhiteList response
func CreateModifyDBClusterAccessWhiteListResponse() (response *ModifyDBClusterAccessWhiteListResponse) {
	response = &ModifyDBClusterAccessWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
