package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeOperatorPermission invokes the adb.RevokeOperatorPermission API synchronously
// api document: https://help.aliyun.com/api/adb/revokeoperatorpermission.html
func (client *Client) RevokeOperatorPermission(request *RevokeOperatorPermissionRequest) (response *RevokeOperatorPermissionResponse, err error) {
	response = CreateRevokeOperatorPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeOperatorPermissionWithChan invokes the adb.RevokeOperatorPermission API asynchronously
// api document: https://help.aliyun.com/api/adb/revokeoperatorpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeOperatorPermissionWithChan(request *RevokeOperatorPermissionRequest) (<-chan *RevokeOperatorPermissionResponse, <-chan error) {
	responseChan := make(chan *RevokeOperatorPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeOperatorPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeOperatorPermissionWithCallback invokes the adb.RevokeOperatorPermission API asynchronously
// api document: https://help.aliyun.com/api/adb/revokeoperatorpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeOperatorPermissionWithCallback(request *RevokeOperatorPermissionRequest, callback func(response *RevokeOperatorPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeOperatorPermissionResponse
		var err error
		defer close(result)
		response, err = client.RevokeOperatorPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeOperatorPermissionRequest is the request struct for api RevokeOperatorPermission
type RevokeOperatorPermissionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// RevokeOperatorPermissionResponse is the response struct for api RevokeOperatorPermission
type RevokeOperatorPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeOperatorPermissionRequest creates a request to invoke RevokeOperatorPermission API
func CreateRevokeOperatorPermissionRequest() (request *RevokeOperatorPermissionRequest) {
	request = &RevokeOperatorPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "RevokeOperatorPermission", "ads", "openAPI")
	return
}

// CreateRevokeOperatorPermissionResponse creates a response to parse from RevokeOperatorPermission response
func CreateRevokeOperatorPermissionResponse() (response *RevokeOperatorPermissionResponse) {
	response = &RevokeOperatorPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
