package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVulLevel invokes the aegis.ModifyVulLevel API synchronously
// api document: https://help.aliyun.com/api/aegis/modifyvullevel.html
func (client *Client) ModifyVulLevel(request *ModifyVulLevelRequest) (response *ModifyVulLevelResponse, err error) {
	response = CreateModifyVulLevelResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVulLevelWithChan invokes the aegis.ModifyVulLevel API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyvullevel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVulLevelWithChan(request *ModifyVulLevelRequest) (<-chan *ModifyVulLevelResponse, <-chan error) {
	responseChan := make(chan *ModifyVulLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVulLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVulLevelWithCallback invokes the aegis.ModifyVulLevel API asynchronously
// api document: https://help.aliyun.com/api/aegis/modifyvullevel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVulLevelWithCallback(request *ModifyVulLevelRequest, callback func(response *ModifyVulLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVulLevelResponse
		var err error
		defer close(result)
		response, err = client.ModifyVulLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVulLevelRequest is the request struct for api ModifyVulLevel
type ModifyVulLevelRequest struct {
	*requests.RpcRequest
	ConcernLevel string `position:"Query" name:"ConcernLevel"`
	SourceIp     string `position:"Query" name:"SourceIp"`
}

// ModifyVulLevelResponse is the response struct for api ModifyVulLevel
type ModifyVulLevelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVulLevelRequest creates a request to invoke ModifyVulLevel API
func CreateModifyVulLevelRequest() (request *ModifyVulLevelRequest) {
	request = &ModifyVulLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ModifyVulLevel", "vipaegis", "openAPI")
	return
}

// CreateModifyVulLevelResponse creates a response to parse from ModifyVulLevel response
func CreateModifyVulLevelResponse() (response *ModifyVulLevelResponse) {
	response = &ModifyVulLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
