package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDomainBackup invokes the alidns.AddDomainBackup API synchronously
// api document: https://help.aliyun.com/api/alidns/adddomainbackup.html
func (client *Client) AddDomainBackup(request *AddDomainBackupRequest) (response *AddDomainBackupResponse, err error) {
	response = CreateAddDomainBackupResponse()
	err = client.DoAction(request, response)
	return
}

// AddDomainBackupWithChan invokes the alidns.AddDomainBackup API asynchronously
// api document: https://help.aliyun.com/api/alidns/adddomainbackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDomainBackupWithChan(request *AddDomainBackupRequest) (<-chan *AddDomainBackupResponse, <-chan error) {
	responseChan := make(chan *AddDomainBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDomainBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDomainBackupWithCallback invokes the alidns.AddDomainBackup API asynchronously
// api document: https://help.aliyun.com/api/alidns/adddomainbackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDomainBackupWithCallback(request *AddDomainBackupRequest, callback func(response *AddDomainBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDomainBackupResponse
		var err error
		defer close(result)
		response, err = client.AddDomainBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDomainBackupRequest is the request struct for api AddDomainBackup
type AddDomainBackupRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	PeriodType   string `position:"Query" name:"PeriodType"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// AddDomainBackupResponse is the response struct for api AddDomainBackup
type AddDomainBackupResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainName string `json:"DomainName" xml:"DomainName"`
	PeriodType string `json:"PeriodType" xml:"PeriodType"`
}

// CreateAddDomainBackupRequest creates a request to invoke AddDomainBackup API
func CreateAddDomainBackupRequest() (request *AddDomainBackupRequest) {
	request = &AddDomainBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddDomainBackup", "alidns", "openAPI")
	return
}

// CreateAddDomainBackupResponse creates a response to parse from AddDomainBackup response
func CreateAddDomainBackupResponse() (response *AddDomainBackupResponse) {
	response = &AddDomainBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
