package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNodeStatus invokes the alikafka.DescribeNodeStatus API synchronously
// api document: https://help.aliyun.com/api/alikafka/describenodestatus.html
func (client *Client) DescribeNodeStatus(request *DescribeNodeStatusRequest) (response *DescribeNodeStatusResponse, err error) {
	response = CreateDescribeNodeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeStatusWithChan invokes the alikafka.DescribeNodeStatus API asynchronously
// api document: https://help.aliyun.com/api/alikafka/describenodestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNodeStatusWithChan(request *DescribeNodeStatusRequest) (<-chan *DescribeNodeStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNodeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeStatusWithCallback invokes the alikafka.DescribeNodeStatus API asynchronously
// api document: https://help.aliyun.com/api/alikafka/describenodestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNodeStatusWithCallback(request *DescribeNodeStatusRequest, callback func(response *DescribeNodeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeNodeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeStatusRequest is the request struct for api DescribeNodeStatus
type DescribeNodeStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeNodeStatusResponse is the response struct for api DescribeNodeStatus
type DescribeNodeStatusResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Success    bool       `json:"Success" xml:"Success"`
	Code       int        `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	StatusList StatusList `json:"StatusList" xml:"StatusList"`
}

// CreateDescribeNodeStatusRequest creates a request to invoke DescribeNodeStatus API
func CreateDescribeNodeStatusRequest() (request *DescribeNodeStatusRequest) {
	request = &DescribeNodeStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "DescribeNodeStatus", "alikafka", "openAPI")
	return
}

// CreateDescribeNodeStatusResponse creates a response to parse from DescribeNodeStatus response
func CreateDescribeNodeStatusResponse() (response *DescribeNodeStatusResponse) {
	response = &DescribeNodeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
