package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchAlertContact invokes the arms.SearchAlertContact API synchronously
// api document: https://help.aliyun.com/api/arms/searchalertcontact.html
func (client *Client) SearchAlertContact(request *SearchAlertContactRequest) (response *SearchAlertContactResponse, err error) {
	response = CreateSearchAlertContactResponse()
	err = client.DoAction(request, response)
	return
}

// SearchAlertContactWithChan invokes the arms.SearchAlertContact API asynchronously
// api document: https://help.aliyun.com/api/arms/searchalertcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchAlertContactWithChan(request *SearchAlertContactRequest) (<-chan *SearchAlertContactResponse, <-chan error) {
	responseChan := make(chan *SearchAlertContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchAlertContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchAlertContactWithCallback invokes the arms.SearchAlertContact API asynchronously
// api document: https://help.aliyun.com/api/arms/searchalertcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchAlertContactWithCallback(request *SearchAlertContactRequest, callback func(response *SearchAlertContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchAlertContactResponse
		var err error
		defer close(result)
		response, err = client.SearchAlertContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchAlertContactRequest is the request struct for api SearchAlertContact
type SearchAlertContactRequest struct {
	*requests.RpcRequest
	ContactName string `position:"Query" name:"ContactName"`
	Phone       string `position:"Query" name:"Phone"`
	PageSize    string `position:"Query" name:"PageSize"`
	CurrentPage string `position:"Query" name:"CurrentPage"`
	Email       string `position:"Query" name:"Email"`
}

// SearchAlertContactResponse is the response struct for api SearchAlertContact
type SearchAlertContactResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateSearchAlertContactRequest creates a request to invoke SearchAlertContact API
func CreateSearchAlertContactRequest() (request *SearchAlertContactRequest) {
	request = &SearchAlertContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchAlertContact", "arms", "openAPI")
	return
}

// CreateSearchAlertContactResponse creates a response to parse from SearchAlertContact response
func CreateSearchAlertContactResponse() (response *SearchAlertContactResponse) {
	response = &SearchAlertContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
