package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeResourcePackage invokes the bssopenapi.UpgradeResourcePackage API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/upgraderesourcepackage.html
func (client *Client) UpgradeResourcePackage(request *UpgradeResourcePackageRequest) (response *UpgradeResourcePackageResponse, err error) {
	response = CreateUpgradeResourcePackageResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeResourcePackageWithChan invokes the bssopenapi.UpgradeResourcePackage API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/upgraderesourcepackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeResourcePackageWithChan(request *UpgradeResourcePackageRequest) (<-chan *UpgradeResourcePackageResponse, <-chan error) {
	responseChan := make(chan *UpgradeResourcePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeResourcePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeResourcePackageWithCallback invokes the bssopenapi.UpgradeResourcePackage API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/upgraderesourcepackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpgradeResourcePackageWithCallback(request *UpgradeResourcePackageRequest, callback func(response *UpgradeResourcePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeResourcePackageResponse
		var err error
		defer close(result)
		response, err = client.UpgradeResourcePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeResourcePackageRequest is the request struct for api UpgradeResourcePackage
type UpgradeResourcePackageRequest struct {
	*requests.RpcRequest
	Specification string           `position:"Query" name:"Specification"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	EffectiveDate string           `position:"Query" name:"EffectiveDate"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
}

// UpgradeResourcePackageResponse is the response struct for api UpgradeResourcePackage
type UpgradeResourcePackageResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	OrderId   int64                        `json:"OrderId" xml:"OrderId"`
	Success   bool                         `json:"Success" xml:"Success"`
	Code      string                       `json:"Code" xml:"Code"`
	Message   string                       `json:"Message" xml:"Message"`
	Data      DataInUpgradeResourcePackage `json:"Data" xml:"Data"`
}

// CreateUpgradeResourcePackageRequest creates a request to invoke UpgradeResourcePackage API
func CreateUpgradeResourcePackageRequest() (request *UpgradeResourcePackageRequest) {
	request = &UpgradeResourcePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "UpgradeResourcePackage", "", "")
	return
}

// CreateUpgradeResourcePackageResponse creates a response to parse from UpgradeResourcePackage response
func CreateUpgradeResourcePackageResponse() (response *UpgradeResourcePackageResponse) {
	response = &UpgradeResourcePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
