package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDVOrderResult invokes the cas.DescribeDVOrderResult API synchronously
// api document: https://help.aliyun.com/api/cas/describedvorderresult.html
func (client *Client) DescribeDVOrderResult(request *DescribeDVOrderResultRequest) (response *DescribeDVOrderResultResponse, err error) {
	response = CreateDescribeDVOrderResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDVOrderResultWithChan invokes the cas.DescribeDVOrderResult API asynchronously
// api document: https://help.aliyun.com/api/cas/describedvorderresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDVOrderResultWithChan(request *DescribeDVOrderResultRequest) (<-chan *DescribeDVOrderResultResponse, <-chan error) {
	responseChan := make(chan *DescribeDVOrderResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDVOrderResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDVOrderResultWithCallback invokes the cas.DescribeDVOrderResult API asynchronously
// api document: https://help.aliyun.com/api/cas/describedvorderresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDVOrderResultWithCallback(request *DescribeDVOrderResultRequest, callback func(response *DescribeDVOrderResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDVOrderResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeDVOrderResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDVOrderResultRequest is the request struct for api DescribeDVOrderResult
type DescribeDVOrderResultRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeDVOrderResultResponse is the response struct for api DescribeDVOrderResult
type DescribeDVOrderResultResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	OrderStatus string `json:"OrderStatus" xml:"OrderStatus"`
	Certificate string `json:"Certificate" xml:"Certificate"`
	PrivateKey  string `json:"PrivateKey" xml:"PrivateKey"`
	CheckName   string `json:"CheckName" xml:"CheckName"`
	CheckValue  string `json:"CheckValue" xml:"CheckValue"`
	CheckType   string `json:"CheckType" xml:"CheckType"`
}

// CreateDescribeDVOrderResultRequest creates a request to invoke DescribeDVOrderResult API
func CreateDescribeDVOrderResultRequest() (request *DescribeDVOrderResultRequest) {
	request = &DescribeDVOrderResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2018-07-13", "DescribeDVOrderResult", "cas", "openAPI")
	return
}

// CreateDescribeDVOrderResultResponse creates a response to parse from DescribeDVOrderResult response
func CreateDescribeDVOrderResultResponse() (response *DescribeDVOrderResultResponse) {
	response = &DescribeDVOrderResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
