package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceSummaryReport invokes the ccc.GetInstanceSummaryReport API synchronously
// api document: https://help.aliyun.com/api/ccc/getinstancesummaryreport.html
func (client *Client) GetInstanceSummaryReport(request *GetInstanceSummaryReportRequest) (response *GetInstanceSummaryReportResponse, err error) {
	response = CreateGetInstanceSummaryReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceSummaryReportWithChan invokes the ccc.GetInstanceSummaryReport API asynchronously
// api document: https://help.aliyun.com/api/ccc/getinstancesummaryreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceSummaryReportWithChan(request *GetInstanceSummaryReportRequest) (<-chan *GetInstanceSummaryReportResponse, <-chan error) {
	responseChan := make(chan *GetInstanceSummaryReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceSummaryReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceSummaryReportWithCallback invokes the ccc.GetInstanceSummaryReport API asynchronously
// api document: https://help.aliyun.com/api/ccc/getinstancesummaryreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceSummaryReportWithCallback(request *GetInstanceSummaryReportRequest, callback func(response *GetInstanceSummaryReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceSummaryReportResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceSummaryReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceSummaryReportRequest is the request struct for api GetInstanceSummaryReport
type GetInstanceSummaryReportRequest struct {
	*requests.RpcRequest
	EndTime    string           `position:"Query" name:"EndTime"`
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// GetInstanceSummaryReportResponse is the response struct for api GetInstanceSummaryReport
type GetInstanceSummaryReportResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	Success               bool                  `json:"Success" xml:"Success"`
	Code                  string                `json:"Code" xml:"Code"`
	Message               string                `json:"Message" xml:"Message"`
	HttpStatusCode        int                   `json:"HttpStatusCode" xml:"HttpStatusCode"`
	InstanceSummaryReport InstanceSummaryReport `json:"InstanceSummaryReport" xml:"InstanceSummaryReport"`
}

// CreateGetInstanceSummaryReportRequest creates a request to invoke GetInstanceSummaryReport API
func CreateGetInstanceSummaryReportRequest() (request *GetInstanceSummaryReportRequest) {
	request = &GetInstanceSummaryReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetInstanceSummaryReport", "", "")
	return
}

// CreateGetInstanceSummaryReportResponse creates a response to parse from GetInstanceSummaryReport response
func CreateGetInstanceSummaryReportResponse() (response *GetInstanceSummaryReportResponse) {
	response = &GetInstanceSummaryReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
