package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LaunchAppraise invokes the ccc.LaunchAppraise API synchronously
// api document: https://help.aliyun.com/api/ccc/launchappraise.html
func (client *Client) LaunchAppraise(request *LaunchAppraiseRequest) (response *LaunchAppraiseResponse, err error) {
	response = CreateLaunchAppraiseResponse()
	err = client.DoAction(request, response)
	return
}

// LaunchAppraiseWithChan invokes the ccc.LaunchAppraise API asynchronously
// api document: https://help.aliyun.com/api/ccc/launchappraise.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LaunchAppraiseWithChan(request *LaunchAppraiseRequest) (<-chan *LaunchAppraiseResponse, <-chan error) {
	responseChan := make(chan *LaunchAppraiseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LaunchAppraise(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LaunchAppraiseWithCallback invokes the ccc.LaunchAppraise API asynchronously
// api document: https://help.aliyun.com/api/ccc/launchappraise.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LaunchAppraiseWithCallback(request *LaunchAppraiseRequest, callback func(response *LaunchAppraiseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LaunchAppraiseResponse
		var err error
		defer close(result)
		response, err = client.LaunchAppraise(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LaunchAppraiseRequest is the request struct for api LaunchAppraise
type LaunchAppraiseRequest struct {
	*requests.RpcRequest
	Acid       string `position:"Query" name:"Acid"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// LaunchAppraiseResponse is the response struct for api LaunchAppraise
type LaunchAppraiseResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateLaunchAppraiseRequest creates a request to invoke LaunchAppraise API
func CreateLaunchAppraiseRequest() (request *LaunchAppraiseRequest) {
	request = &LaunchAppraiseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "LaunchAppraise", "", "")
	return
}

// CreateLaunchAppraiseResponse creates a response to parse from LaunchAppraise response
func CreateLaunchAppraiseResponse() (response *LaunchAppraiseResponse) {
	response = &LaunchAppraiseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
