package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepoTriggerLog invokes the cr.ListRepoTriggerLog API synchronously
// api document: https://help.aliyun.com/api/cr/listrepotriggerlog.html
func (client *Client) ListRepoTriggerLog(request *ListRepoTriggerLogRequest) (response *ListRepoTriggerLogResponse, err error) {
	response = CreateListRepoTriggerLogResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepoTriggerLogWithChan invokes the cr.ListRepoTriggerLog API asynchronously
// api document: https://help.aliyun.com/api/cr/listrepotriggerlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoTriggerLogWithChan(request *ListRepoTriggerLogRequest) (<-chan *ListRepoTriggerLogResponse, <-chan error) {
	responseChan := make(chan *ListRepoTriggerLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepoTriggerLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepoTriggerLogWithCallback invokes the cr.ListRepoTriggerLog API asynchronously
// api document: https://help.aliyun.com/api/cr/listrepotriggerlog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRepoTriggerLogWithCallback(request *ListRepoTriggerLogRequest, callback func(response *ListRepoTriggerLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepoTriggerLogResponse
		var err error
		defer close(result)
		response, err = client.ListRepoTriggerLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepoTriggerLogRequest is the request struct for api ListRepoTriggerLog
type ListRepoTriggerLogRequest struct {
	*requests.RpcRequest
	RepoId          string `position:"Query" name:"RepoId"`
	TriggerId       string `position:"Query" name:"TriggerId"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	TriggerRecordId string `position:"Query" name:"TriggerRecordId"`
}

// ListRepoTriggerLogResponse is the response struct for api ListRepoTriggerLog
type ListRepoTriggerLogResponse struct {
	*responses.BaseResponse
	ListRepoTriggerLogIsSuccess bool       `json:"IsSuccess" xml:"IsSuccess"`
	Code                        string     `json:"Code" xml:"Code"`
	RequestId                   string     `json:"RequestId" xml:"RequestId"`
	Logs                        []LogsItem `json:"Logs" xml:"Logs"`
}

// CreateListRepoTriggerLogRequest creates a request to invoke ListRepoTriggerLog API
func CreateListRepoTriggerLogRequest() (request *ListRepoTriggerLogRequest) {
	request = &ListRepoTriggerLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListRepoTriggerLog", "cr", "openAPI")
	return
}

// CreateListRepoTriggerLogResponse creates a response to parse from ListRepoTriggerLog response
func CreateListRepoTriggerLogResponse() (response *ListRepoTriggerLogResponse) {
	response = &ListRepoTriggerLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
