package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateChartNamespace invokes the cr.UpdateChartNamespace API synchronously
// api document: https://help.aliyun.com/api/cr/updatechartnamespace.html
func (client *Client) UpdateChartNamespace(request *UpdateChartNamespaceRequest) (response *UpdateChartNamespaceResponse, err error) {
	response = CreateUpdateChartNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateChartNamespaceWithChan invokes the cr.UpdateChartNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/updatechartnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateChartNamespaceWithChan(request *UpdateChartNamespaceRequest) (<-chan *UpdateChartNamespaceResponse, <-chan error) {
	responseChan := make(chan *UpdateChartNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateChartNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateChartNamespaceWithCallback invokes the cr.UpdateChartNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/updatechartnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateChartNamespaceWithCallback(request *UpdateChartNamespaceRequest, callback func(response *UpdateChartNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateChartNamespaceResponse
		var err error
		defer close(result)
		response, err = client.UpdateChartNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateChartNamespaceRequest is the request struct for api UpdateChartNamespace
type UpdateChartNamespaceRequest struct {
	*requests.RpcRequest
	NamespaceName   string           `position:"Query" name:"NamespaceName"`
	AutoCreateRepo  requests.Boolean `position:"Query" name:"AutoCreateRepo"`
	DefaultRepoType string           `position:"Query" name:"DefaultRepoType"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// UpdateChartNamespaceResponse is the response struct for api UpdateChartNamespace
type UpdateChartNamespaceResponse struct {
	*responses.BaseResponse
	UpdateChartNamespaceIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                          string `json:"Code" xml:"Code"`
	RequestId                     string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateChartNamespaceRequest creates a request to invoke UpdateChartNamespace API
func CreateUpdateChartNamespaceRequest() (request *UpdateChartNamespaceRequest) {
	request = &UpdateChartNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "UpdateChartNamespace", "cr", "openAPI")
	return
}

// CreateUpdateChartNamespaceResponse creates a response to parse from UpdateChartNamespace response
func CreateUpdateChartNamespaceResponse() (response *UpdateChartNamespaceResponse) {
	response = &UpdateChartNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
