package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateOrderList invokes the csb.UpdateOrderList API synchronously
// api document: https://help.aliyun.com/api/csb/updateorderlist.html
func (client *Client) UpdateOrderList(request *UpdateOrderListRequest) (response *UpdateOrderListResponse, err error) {
	response = CreateUpdateOrderListResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateOrderListWithChan invokes the csb.UpdateOrderList API asynchronously
// api document: https://help.aliyun.com/api/csb/updateorderlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateOrderListWithChan(request *UpdateOrderListRequest) (<-chan *UpdateOrderListResponse, <-chan error) {
	responseChan := make(chan *UpdateOrderListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateOrderList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateOrderListWithCallback invokes the csb.UpdateOrderList API asynchronously
// api document: https://help.aliyun.com/api/csb/updateorderlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateOrderListWithCallback(request *UpdateOrderListRequest, callback func(response *UpdateOrderListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateOrderListResponse
		var err error
		defer close(result)
		response, err = client.UpdateOrderList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateOrderListRequest is the request struct for api UpdateOrderList
type UpdateOrderListRequest struct {
	*requests.RpcRequest
	Data string `position:"Body" name:"Data"`
}

// UpdateOrderListResponse is the response struct for api UpdateOrderList
type UpdateOrderListResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateOrderListRequest creates a request to invoke UpdateOrderList API
func CreateUpdateOrderListRequest() (request *UpdateOrderListRequest) {
	request = &UpdateOrderListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "UpdateOrderList", "", "")
	return
}

// CreateUpdateOrderListResponse creates a response to parse from UpdateOrderList response
func CreateUpdateOrderListResponse() (response *UpdateOrderListResponse) {
	response = &UpdateOrderListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
