package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDcdnDomain invokes the dcdn.AddDcdnDomain API synchronously
// api document: https://help.aliyun.com/api/dcdn/adddcdndomain.html
func (client *Client) AddDcdnDomain(request *AddDcdnDomainRequest) (response *AddDcdnDomainResponse, err error) {
	response = CreateAddDcdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// AddDcdnDomainWithChan invokes the dcdn.AddDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/adddcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDcdnDomainWithChan(request *AddDcdnDomainRequest) (<-chan *AddDcdnDomainResponse, <-chan error) {
	responseChan := make(chan *AddDcdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDcdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDcdnDomainWithCallback invokes the dcdn.AddDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/adddcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddDcdnDomainWithCallback(request *AddDcdnDomainRequest, callback func(response *AddDcdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDcdnDomainResponse
		var err error
		defer close(result)
		response, err = client.AddDcdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDcdnDomainRequest is the request struct for api AddDcdnDomain
type AddDcdnDomainRequest struct {
	*requests.RpcRequest
	Sources         string           `position:"Query" name:"Sources"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	Scope           string           `position:"Query" name:"Scope"`
	TopLevelDomain  string           `position:"Query" name:"TopLevelDomain"`
	OwnerAccount    string           `position:"Query" name:"OwnerAccount"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	CheckUrl        string           `position:"Query" name:"CheckUrl"`
}

// AddDcdnDomainResponse is the response struct for api AddDcdnDomain
type AddDcdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddDcdnDomainRequest creates a request to invoke AddDcdnDomain API
func CreateAddDcdnDomainRequest() (request *AddDcdnDomainRequest) {
	request = &AddDcdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "AddDcdnDomain", "", "")
	return
}

// CreateAddDcdnDomainResponse creates a response to parse from AddDcdnDomain response
func CreateAddDcdnDomainResponse() (response *AddDcdnDomainResponse) {
	response = &AddDcdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
