package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStartDcdnDomain invokes the dcdn.BatchStartDcdnDomain API synchronously
// api document: https://help.aliyun.com/api/dcdn/batchstartdcdndomain.html
func (client *Client) BatchStartDcdnDomain(request *BatchStartDcdnDomainRequest) (response *BatchStartDcdnDomainResponse, err error) {
	response = CreateBatchStartDcdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStartDcdnDomainWithChan invokes the dcdn.BatchStartDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/batchstartdcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchStartDcdnDomainWithChan(request *BatchStartDcdnDomainRequest) (<-chan *BatchStartDcdnDomainResponse, <-chan error) {
	responseChan := make(chan *BatchStartDcdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStartDcdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStartDcdnDomainWithCallback invokes the dcdn.BatchStartDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/batchstartdcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchStartDcdnDomainWithCallback(request *BatchStartDcdnDomainRequest, callback func(response *BatchStartDcdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStartDcdnDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchStartDcdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStartDcdnDomainRequest is the request struct for api BatchStartDcdnDomain
type BatchStartDcdnDomainRequest struct {
	*requests.RpcRequest
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchStartDcdnDomainResponse is the response struct for api BatchStartDcdnDomain
type BatchStartDcdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchStartDcdnDomainRequest creates a request to invoke BatchStartDcdnDomain API
func CreateBatchStartDcdnDomainRequest() (request *BatchStartDcdnDomainRequest) {
	request = &BatchStartDcdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchStartDcdnDomain", "", "")
	return
}

// CreateBatchStartDcdnDomainResponse creates a response to parse from BatchStartDcdnDomain response
func CreateBatchStartDcdnDomainResponse() (response *BatchStartDcdnDomainResponse) {
	response = &BatchStartDcdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
