package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainRealTimeDetailData invokes the dcdn.DescribeDcdnDomainRealTimeDetailData API synchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainrealtimedetaildata.html
func (client *Client) DescribeDcdnDomainRealTimeDetailData(request *DescribeDcdnDomainRealTimeDetailDataRequest) (response *DescribeDcdnDomainRealTimeDetailDataResponse, err error) {
	response = CreateDescribeDcdnDomainRealTimeDetailDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainRealTimeDetailDataWithChan invokes the dcdn.DescribeDcdnDomainRealTimeDetailData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainrealtimedetaildata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainRealTimeDetailDataWithChan(request *DescribeDcdnDomainRealTimeDetailDataRequest) (<-chan *DescribeDcdnDomainRealTimeDetailDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainRealTimeDetailDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainRealTimeDetailData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainRealTimeDetailDataWithCallback invokes the dcdn.DescribeDcdnDomainRealTimeDetailData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomainrealtimedetaildata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainRealTimeDetailDataWithCallback(request *DescribeDcdnDomainRealTimeDetailDataRequest, callback func(response *DescribeDcdnDomainRealTimeDetailDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainRealTimeDetailDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainRealTimeDetailData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainRealTimeDetailDataRequest is the request struct for api DescribeDcdnDomainRealTimeDetailData
type DescribeDcdnDomainRealTimeDetailDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	Merge          string           `position:"Query" name:"Merge"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	MergeLocIsp    string           `position:"Query" name:"MergeLocIsp"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Field          string           `position:"Query" name:"Field"`
}

// DescribeDcdnDomainRealTimeDetailDataResponse is the response struct for api DescribeDcdnDomainRealTimeDetailData
type DescribeDcdnDomainRealTimeDetailDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDescribeDcdnDomainRealTimeDetailDataRequest creates a request to invoke DescribeDcdnDomainRealTimeDetailData API
func CreateDescribeDcdnDomainRealTimeDetailDataRequest() (request *DescribeDcdnDomainRealTimeDetailDataRequest) {
	request = &DescribeDcdnDomainRealTimeDetailDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainRealTimeDetailData", "", "")
	return
}

// CreateDescribeDcdnDomainRealTimeDetailDataResponse creates a response to parse from DescribeDcdnDomainRealTimeDetailData response
func CreateDescribeDcdnDomainRealTimeDetailDataResponse() (response *DescribeDcdnDomainRealTimeDetailDataResponse) {
	response = &DescribeDcdnDomainRealTimeDetailDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
