package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainTrafficData invokes the dcdn.DescribeDcdnDomainTrafficData API synchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomaintrafficdata.html
func (client *Client) DescribeDcdnDomainTrafficData(request *DescribeDcdnDomainTrafficDataRequest) (response *DescribeDcdnDomainTrafficDataResponse, err error) {
	response = CreateDescribeDcdnDomainTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainTrafficDataWithChan invokes the dcdn.DescribeDcdnDomainTrafficData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomaintrafficdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainTrafficDataWithChan(request *DescribeDcdnDomainTrafficDataRequest) (<-chan *DescribeDcdnDomainTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainTrafficDataWithCallback invokes the dcdn.DescribeDcdnDomainTrafficData API asynchronously
// api document: https://help.aliyun.com/api/dcdn/describedcdndomaintrafficdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDcdnDomainTrafficDataWithCallback(request *DescribeDcdnDomainTrafficDataRequest, callback func(response *DescribeDcdnDomainTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainTrafficDataRequest is the request struct for api DescribeDcdnDomainTrafficData
type DescribeDcdnDomainTrafficDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeDcdnDomainTrafficDataResponse is the response struct for api DescribeDcdnDomainTrafficData
type DescribeDcdnDomainTrafficDataResponse struct {
	*responses.BaseResponse
	RequestId              string                                                `json:"RequestId" xml:"RequestId"`
	DomainName             string                                                `json:"DomainName" xml:"DomainName"`
	StartTime              string                                                `json:"StartTime" xml:"StartTime"`
	EndTime                string                                                `json:"EndTime" xml:"EndTime"`
	DataInterval           string                                                `json:"DataInterval" xml:"DataInterval"`
	TrafficDataPerInterval TrafficDataPerIntervalInDescribeDcdnDomainTrafficData `json:"TrafficDataPerInterval" xml:"TrafficDataPerInterval"`
}

// CreateDescribeDcdnDomainTrafficDataRequest creates a request to invoke DescribeDcdnDomainTrafficData API
func CreateDescribeDcdnDomainTrafficDataRequest() (request *DescribeDcdnDomainTrafficDataRequest) {
	request = &DescribeDcdnDomainTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainTrafficData", "", "")
	return
}

// CreateDescribeDcdnDomainTrafficDataResponse creates a response to parse from DescribeDcdnDomainTrafficData response
func CreateDescribeDcdnDomainTrafficDataResponse() (response *DescribeDcdnDomainTrafficDataResponse) {
	response = &DescribeDcdnDomainTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
