package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainTransmitRule invokes the ddospro.DeleteDomainTransmitRule API synchronously
// api document: https://help.aliyun.com/api/ddospro/deletedomaintransmitrule.html
func (client *Client) DeleteDomainTransmitRule(request *DeleteDomainTransmitRuleRequest) (response *DeleteDomainTransmitRuleResponse, err error) {
	response = CreateDeleteDomainTransmitRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainTransmitRuleWithChan invokes the ddospro.DeleteDomainTransmitRule API asynchronously
// api document: https://help.aliyun.com/api/ddospro/deletedomaintransmitrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDomainTransmitRuleWithChan(request *DeleteDomainTransmitRuleRequest) (<-chan *DeleteDomainTransmitRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainTransmitRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainTransmitRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainTransmitRuleWithCallback invokes the ddospro.DeleteDomainTransmitRule API asynchronously
// api document: https://help.aliyun.com/api/ddospro/deletedomaintransmitrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteDomainTransmitRuleWithCallback(request *DeleteDomainTransmitRuleRequest, callback func(response *DeleteDomainTransmitRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainTransmitRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainTransmitRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainTransmitRuleRequest is the request struct for api DeleteDomainTransmitRule
type DeleteDomainTransmitRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	Ip              string           `position:"Query" name:"Ip"`
}

// DeleteDomainTransmitRuleResponse is the response struct for api DeleteDomainTransmitRule
type DeleteDomainTransmitRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDomainTransmitRuleRequest creates a request to invoke DeleteDomainTransmitRule API
func CreateDeleteDomainTransmitRuleRequest() (request *DeleteDomainTransmitRuleRequest) {
	request = &DeleteDomainTransmitRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DeleteDomainTransmitRule", "", "")
	return
}

// CreateDeleteDomainTransmitRuleResponse creates a response to parse from DeleteDomainTransmitRule response
func CreateDeleteDomainTransmitRuleResponse() (response *DeleteDomainTransmitRuleResponse) {
	response = &DeleteDomainTransmitRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
