package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailableEngineVersion invokes the dds.DescribeAvailableEngineVersion API synchronously
// api document: https://help.aliyun.com/api/dds/describeavailableengineversion.html
func (client *Client) DescribeAvailableEngineVersion(request *DescribeAvailableEngineVersionRequest) (response *DescribeAvailableEngineVersionResponse, err error) {
	response = CreateDescribeAvailableEngineVersionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailableEngineVersionWithChan invokes the dds.DescribeAvailableEngineVersion API asynchronously
// api document: https://help.aliyun.com/api/dds/describeavailableengineversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAvailableEngineVersionWithChan(request *DescribeAvailableEngineVersionRequest) (<-chan *DescribeAvailableEngineVersionResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailableEngineVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailableEngineVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailableEngineVersionWithCallback invokes the dds.DescribeAvailableEngineVersion API asynchronously
// api document: https://help.aliyun.com/api/dds/describeavailableengineversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAvailableEngineVersionWithCallback(request *DescribeAvailableEngineVersionRequest, callback func(response *DescribeAvailableEngineVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailableEngineVersionResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailableEngineVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailableEngineVersionRequest is the request struct for api DescribeAvailableEngineVersion
type DescribeAvailableEngineVersionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAvailableEngineVersionResponse is the response struct for api DescribeAvailableEngineVersion
type DescribeAvailableEngineVersionResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	EngineVersions EngineVersions `json:"EngineVersions" xml:"EngineVersions"`
}

// CreateDescribeAvailableEngineVersionRequest creates a request to invoke DescribeAvailableEngineVersion API
func CreateDescribeAvailableEngineVersionRequest() (request *DescribeAvailableEngineVersionRequest) {
	request = &DescribeAvailableEngineVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeAvailableEngineVersion", "dds", "openAPI")
	return
}

// CreateDescribeAvailableEngineVersionResponse creates a response to parse from DescribeAvailableEngineVersion response
func CreateDescribeAvailableEngineVersionResponse() (response *DescribeAvailableEngineVersionResponse) {
	response = &DescribeAvailableEngineVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
