package dnsknocker

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeResourceRecords invokes the dnsknocker.ChangeResourceRecords API synchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecords.html
func (client *Client) ChangeResourceRecords(request *ChangeResourceRecordsRequest) (response *ChangeResourceRecordsResponse, err error) {
	response = CreateChangeResourceRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeResourceRecordsWithChan invokes the dnsknocker.ChangeResourceRecords API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeResourceRecordsWithChan(request *ChangeResourceRecordsRequest) (<-chan *ChangeResourceRecordsResponse, <-chan error) {
	responseChan := make(chan *ChangeResourceRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeResourceRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeResourceRecordsWithCallback invokes the dnsknocker.ChangeResourceRecords API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/changeresourcerecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ChangeResourceRecordsWithCallback(request *ChangeResourceRecordsRequest, callback func(response *ChangeResourceRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeResourceRecordsResponse
		var err error
		defer close(result)
		response, err = client.ChangeResourceRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeResourceRecordsRequest is the request struct for api ChangeResourceRecords
type ChangeResourceRecordsRequest struct {
	*requests.RpcRequest
	AccessID        string `position:"Body" name:"AccessID"`
	AccessSecret    string `position:"Body" name:"AccessSecret"`
	Types           string `position:"Body" name:"Types"`
	ResourceRecords string `position:"Body" name:"ResourceRecords"`
	Line            string `position:"Body" name:"Line"`
	DomainName      string `position:"Body" name:"DomainName"`
	ZoneName        string `position:"Body" name:"ZoneName"`
	TransactionId   string `position:"Body" name:"TransactionId"`
	Group           string `position:"Body" name:"Group"`
}

// ChangeResourceRecordsResponse is the response struct for api ChangeResourceRecords
type ChangeResourceRecordsResponse struct {
	*responses.BaseResponse
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	Success       bool   `json:"Success" xml:"Success"`
	TransactionId string `json:"TransactionId" xml:"TransactionId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateChangeResourceRecordsRequest creates a request to invoke ChangeResourceRecords API
func CreateChangeResourceRecordsRequest() (request *ChangeResourceRecordsRequest) {
	request = &ChangeResourceRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DnsKnocker", "2019-09-10", "ChangeResourceRecords", "dns_knocker", "openAPI")
	return
}

// CreateChangeResourceRecordsResponse creates a response to parse from ChangeResourceRecords response
func CreateChangeResourceRecordsResponse() (response *ChangeResourceRecordsResponse) {
	response = &ChangeResourceRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
