package dnsknocker

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDomain invokes the dnsknocker.GetDomain API synchronously
// api document: https://help.aliyun.com/api/dnsknocker/getdomain.html
func (client *Client) GetDomain(request *GetDomainRequest) (response *GetDomainResponse, err error) {
	response = CreateGetDomainResponse()
	err = client.DoAction(request, response)
	return
}

// GetDomainWithChan invokes the dnsknocker.GetDomain API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/getdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDomainWithChan(request *GetDomainRequest) (<-chan *GetDomainResponse, <-chan error) {
	responseChan := make(chan *GetDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDomainWithCallback invokes the dnsknocker.GetDomain API asynchronously
// api document: https://help.aliyun.com/api/dnsknocker/getdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDomainWithCallback(request *GetDomainRequest, callback func(response *GetDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDomainResponse
		var err error
		defer close(result)
		response, err = client.GetDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDomainRequest is the request struct for api GetDomain
type GetDomainRequest struct {
	*requests.RpcRequest
	AccessID     string `position:"Body" name:"AccessID"`
	AccessSecret string `position:"Body" name:"AccessSecret"`
	DomainName   string `position:"Body" name:"DomainName"`
	DomainLine   string `position:"Body" name:"DomainLine"`
	Group        string `position:"Body" name:"Group"`
}

// GetDomainResponse is the response struct for api GetDomain
type GetDomainResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	Success       string `json:"Success" xml:"Success"`
	TransactionId string `json:"TransactionId" xml:"TransactionId"`
	Domain        []Data `json:"Domain" xml:"Domain"`
}

// CreateGetDomainRequest creates a request to invoke GetDomain API
func CreateGetDomainRequest() (request *GetDomainRequest) {
	request = &GetDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DnsKnocker", "2019-09-10", "GetDomain", "dns_knocker", "openAPI")
	return
}

// CreateGetDomainResponse creates a response to parse from GetDomain response
func CreateGetDomainResponse() (response *GetDomainResponse) {
	response = &GetDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
