package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceMenuSwitch invokes the drds.DescribeInstanceMenuSwitch API synchronously
// api document: https://help.aliyun.com/api/drds/describeinstancemenuswitch.html
func (client *Client) DescribeInstanceMenuSwitch(request *DescribeInstanceMenuSwitchRequest) (response *DescribeInstanceMenuSwitchResponse, err error) {
	response = CreateDescribeInstanceMenuSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceMenuSwitchWithChan invokes the drds.DescribeInstanceMenuSwitch API asynchronously
// api document: https://help.aliyun.com/api/drds/describeinstancemenuswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceMenuSwitchWithChan(request *DescribeInstanceMenuSwitchRequest) (<-chan *DescribeInstanceMenuSwitchResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceMenuSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceMenuSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceMenuSwitchWithCallback invokes the drds.DescribeInstanceMenuSwitch API asynchronously
// api document: https://help.aliyun.com/api/drds/describeinstancemenuswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeInstanceMenuSwitchWithCallback(request *DescribeInstanceMenuSwitchRequest, callback func(response *DescribeInstanceMenuSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceMenuSwitchResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceMenuSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceMenuSwitchRequest is the request struct for api DescribeInstanceMenuSwitch
type DescribeInstanceMenuSwitchRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeInstanceMenuSwitchResponse is the response struct for api DescribeInstanceMenuSwitch
type DescribeInstanceMenuSwitchResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   bool                   `json:"Success" xml:"Success"`
	Config    map[string]interface{} `json:"Config" xml:"Config"`
}

// CreateDescribeInstanceMenuSwitchRequest creates a request to invoke DescribeInstanceMenuSwitch API
func CreateDescribeInstanceMenuSwitchRequest() (request *DescribeInstanceMenuSwitchRequest) {
	request = &DescribeInstanceMenuSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeInstanceMenuSwitch", "Drds", "openAPI")
	return
}

// CreateDescribeInstanceMenuSwitchResponse creates a response to parse from DescribeInstanceMenuSwitch response
func CreateDescribeInstanceMenuSwitchResponse() (response *DescribeInstanceMenuSwitchResponse) {
	response = &DescribeInstanceMenuSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
