package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRdsPerformanceSummary invokes the drds.DescribeRdsPerformanceSummary API synchronously
// api document: https://help.aliyun.com/api/drds/describerdsperformancesummary.html
func (client *Client) DescribeRdsPerformanceSummary(request *DescribeRdsPerformanceSummaryRequest) (response *DescribeRdsPerformanceSummaryResponse, err error) {
	response = CreateDescribeRdsPerformanceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRdsPerformanceSummaryWithChan invokes the drds.DescribeRdsPerformanceSummary API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdsperformancesummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsPerformanceSummaryWithChan(request *DescribeRdsPerformanceSummaryRequest) (<-chan *DescribeRdsPerformanceSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeRdsPerformanceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRdsPerformanceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRdsPerformanceSummaryWithCallback invokes the drds.DescribeRdsPerformanceSummary API asynchronously
// api document: https://help.aliyun.com/api/drds/describerdsperformancesummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRdsPerformanceSummaryWithCallback(request *DescribeRdsPerformanceSummaryRequest, callback func(response *DescribeRdsPerformanceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRdsPerformanceSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeRdsPerformanceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRdsPerformanceSummaryRequest is the request struct for api DescribeRdsPerformanceSummary
type DescribeRdsPerformanceSummaryRequest struct {
	*requests.RpcRequest
	RdsInstanceId  *[]string `position:"Query" name:"RdsInstanceId"  type:"Repeated"`
	DrdsInstanceId string    `position:"Query" name:"DrdsInstanceId"`
}

// DescribeRdsPerformanceSummaryResponse is the response struct for api DescribeRdsPerformanceSummary
type DescribeRdsPerformanceSummaryResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	Success             bool                 `json:"Success" xml:"Success"`
	RdsPerformanceInfos []RdsPerformanceInfo `json:"RdsPerformanceInfos" xml:"RdsPerformanceInfos"`
}

// CreateDescribeRdsPerformanceSummaryRequest creates a request to invoke DescribeRdsPerformanceSummary API
func CreateDescribeRdsPerformanceSummaryRequest() (request *DescribeRdsPerformanceSummaryRequest) {
	request = &DescribeRdsPerformanceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeRdsPerformanceSummary", "Drds", "openAPI")
	return
}

// CreateDescribeRdsPerformanceSummaryResponse creates a response to parse from DescribeRdsPerformanceSummary response
func CreateDescribeRdsPerformanceSummaryResponse() (response *DescribeRdsPerformanceSummaryResponse) {
	response = &DescribeRdsPerformanceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
