package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveDrdsDbFailedRecord invokes the drds.RemoveDrdsDbFailedRecord API synchronously
// api document: https://help.aliyun.com/api/drds/removedrdsdbfailedrecord.html
func (client *Client) RemoveDrdsDbFailedRecord(request *RemoveDrdsDbFailedRecordRequest) (response *RemoveDrdsDbFailedRecordResponse, err error) {
	response = CreateRemoveDrdsDbFailedRecordResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveDrdsDbFailedRecordWithChan invokes the drds.RemoveDrdsDbFailedRecord API asynchronously
// api document: https://help.aliyun.com/api/drds/removedrdsdbfailedrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveDrdsDbFailedRecordWithChan(request *RemoveDrdsDbFailedRecordRequest) (<-chan *RemoveDrdsDbFailedRecordResponse, <-chan error) {
	responseChan := make(chan *RemoveDrdsDbFailedRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveDrdsDbFailedRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveDrdsDbFailedRecordWithCallback invokes the drds.RemoveDrdsDbFailedRecord API asynchronously
// api document: https://help.aliyun.com/api/drds/removedrdsdbfailedrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveDrdsDbFailedRecordWithCallback(request *RemoveDrdsDbFailedRecordRequest, callback func(response *RemoveDrdsDbFailedRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveDrdsDbFailedRecordResponse
		var err error
		defer close(result)
		response, err = client.RemoveDrdsDbFailedRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveDrdsDbFailedRecordRequest is the request struct for api RemoveDrdsDbFailedRecord
type RemoveDrdsDbFailedRecordRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// RemoveDrdsDbFailedRecordResponse is the response struct for api RemoveDrdsDbFailedRecord
type RemoveDrdsDbFailedRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateRemoveDrdsDbFailedRecordRequest creates a request to invoke RemoveDrdsDbFailedRecord API
func CreateRemoveDrdsDbFailedRecordRequest() (request *RemoveDrdsDbFailedRecordRequest) {
	request = &RemoveDrdsDbFailedRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "RemoveDrdsDbFailedRecord", "Drds", "openAPI")
	return
}

// CreateRemoveDrdsDbFailedRecordResponse creates a response to parse from RemoveDrdsDbFailedRecord response
func CreateRemoveDrdsDbFailedRecordResponse() (response *RemoveDrdsDbFailedRecordResponse) {
	response = &RemoveDrdsDbFailedRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
