package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetupTable invokes the drds.SetupTable API synchronously
// api document: https://help.aliyun.com/api/drds/setuptable.html
func (client *Client) SetupTable(request *SetupTableRequest) (response *SetupTableResponse, err error) {
	response = CreateSetupTableResponse()
	err = client.DoAction(request, response)
	return
}

// SetupTableWithChan invokes the drds.SetupTable API asynchronously
// api document: https://help.aliyun.com/api/drds/setuptable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupTableWithChan(request *SetupTableRequest) (<-chan *SetupTableResponse, <-chan error) {
	responseChan := make(chan *SetupTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetupTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetupTableWithCallback invokes the drds.SetupTable API asynchronously
// api document: https://help.aliyun.com/api/drds/setuptable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupTableWithCallback(request *SetupTableRequest, callback func(response *SetupTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetupTableResponse
		var err error
		defer close(result)
		response, err = client.SetupTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetupTableRequest is the request struct for api SetupTable
type SetupTableRequest struct {
	*requests.RpcRequest
	AllowFullTableScan requests.Boolean `position:"Query" name:"AllowFullTableScan"`
	DrdsInstanceId     string           `position:"Query" name:"DrdsInstanceId"`
	DbName             string           `position:"Query" name:"DbName"`
	TableName          *[]string        `position:"Query" name:"TableName"  type:"Repeated"`
}

// SetupTableResponse is the response struct for api SetupTable
type SetupTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSetupTableRequest creates a request to invoke SetupTable API
func CreateSetupTableRequest() (request *SetupTableRequest) {
	request = &SetupTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SetupTable", "Drds", "openAPI")
	return
}

// CreateSetupTableResponse creates a response to parse from SetupTable response
func CreateSetupTableResponse() (response *SetupTableResponse) {
	response = &SetupTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
