package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitCleanTask invokes the drds.SubmitCleanTask API synchronously
// api document: https://help.aliyun.com/api/drds/submitcleantask.html
func (client *Client) SubmitCleanTask(request *SubmitCleanTaskRequest) (response *SubmitCleanTaskResponse, err error) {
	response = CreateSubmitCleanTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitCleanTaskWithChan invokes the drds.SubmitCleanTask API asynchronously
// api document: https://help.aliyun.com/api/drds/submitcleantask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitCleanTaskWithChan(request *SubmitCleanTaskRequest) (<-chan *SubmitCleanTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitCleanTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitCleanTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitCleanTaskWithCallback invokes the drds.SubmitCleanTask API asynchronously
// api document: https://help.aliyun.com/api/drds/submitcleantask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitCleanTaskWithCallback(request *SubmitCleanTaskRequest, callback func(response *SubmitCleanTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitCleanTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitCleanTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitCleanTaskRequest is the request struct for api SubmitCleanTask
type SubmitCleanTaskRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	ExpandType     string `position:"Query" name:"ExpandType"`
	JobId          string `position:"Query" name:"JobId"`
	DbName         string `position:"Query" name:"DbName"`
	ParentJobId    string `position:"Query" name:"ParentJobId"`
}

// SubmitCleanTaskResponse is the response struct for api SubmitCleanTask
type SubmitCleanTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitCleanTaskRequest creates a request to invoke SubmitCleanTask API
func CreateSubmitCleanTaskRequest() (request *SubmitCleanTaskRequest) {
	request = &SubmitCleanTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitCleanTask", "Drds", "openAPI")
	return
}

// CreateSubmitCleanTaskResponse creates a response to parse from SubmitCleanTask response
func CreateSubmitCleanTaskResponse() (response *SubmitCleanTaskResponse) {
	response = &SubmitCleanTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
