package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitRollbackTask invokes the drds.SubmitRollbackTask API synchronously
// api document: https://help.aliyun.com/api/drds/submitrollbacktask.html
func (client *Client) SubmitRollbackTask(request *SubmitRollbackTaskRequest) (response *SubmitRollbackTaskResponse, err error) {
	response = CreateSubmitRollbackTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitRollbackTaskWithChan invokes the drds.SubmitRollbackTask API asynchronously
// api document: https://help.aliyun.com/api/drds/submitrollbacktask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitRollbackTaskWithChan(request *SubmitRollbackTaskRequest) (<-chan *SubmitRollbackTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitRollbackTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitRollbackTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitRollbackTaskWithCallback invokes the drds.SubmitRollbackTask API asynchronously
// api document: https://help.aliyun.com/api/drds/submitrollbacktask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitRollbackTaskWithCallback(request *SubmitRollbackTaskRequest, callback func(response *SubmitRollbackTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitRollbackTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitRollbackTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitRollbackTaskRequest is the request struct for api SubmitRollbackTask
type SubmitRollbackTaskRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	ExpandType     string `position:"Query" name:"ExpandType"`
	JobId          string `position:"Query" name:"JobId"`
	DbName         string `position:"Query" name:"DbName"`
	ParentJobId    string `position:"Query" name:"ParentJobId"`
}

// SubmitRollbackTaskResponse is the response struct for api SubmitRollbackTask
type SubmitRollbackTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitRollbackTaskRequest creates a request to invoke SubmitRollbackTask API
func CreateSubmitRollbackTaskRequest() (request *SubmitRollbackTaskRequest) {
	request = &SubmitRollbackTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitRollbackTask", "Drds", "openAPI")
	return
}

// CreateSubmitRollbackTaskResponse creates a response to parse from SubmitRollbackTask response
func CreateSubmitRollbackTaskResponse() (response *SubmitRollbackTaskResponse) {
	response = &SubmitRollbackTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
