package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchRobotSmartCall invokes the dyvmsapi.BatchRobotSmartCall API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/batchrobotsmartcall.html
func (client *Client) BatchRobotSmartCall(request *BatchRobotSmartCallRequest) (response *BatchRobotSmartCallResponse, err error) {
	response = CreateBatchRobotSmartCallResponse()
	err = client.DoAction(request, response)
	return
}

// BatchRobotSmartCallWithChan invokes the dyvmsapi.BatchRobotSmartCall API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/batchrobotsmartcall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchRobotSmartCallWithChan(request *BatchRobotSmartCallRequest) (<-chan *BatchRobotSmartCallResponse, <-chan error) {
	responseChan := make(chan *BatchRobotSmartCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchRobotSmartCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchRobotSmartCallWithCallback invokes the dyvmsapi.BatchRobotSmartCall API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/batchrobotsmartcall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchRobotSmartCallWithCallback(request *BatchRobotSmartCallRequest, callback func(response *BatchRobotSmartCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchRobotSmartCallResponse
		var err error
		defer close(result)
		response, err = client.BatchRobotSmartCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchRobotSmartCallRequest is the request struct for api BatchRobotSmartCall
type BatchRobotSmartCallRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EarlyMediaAsr        requests.Boolean `position:"Query" name:"EarlyMediaAsr"`
	TtsParamHead         string           `position:"Query" name:"TtsParamHead"`
	TaskName             string           `position:"Query" name:"TaskName"`
	TtsParam             string           `position:"Query" name:"TtsParam"`
	CalledNumber         string           `position:"Query" name:"CalledNumber"`
	CalledShowNumber     string           `position:"Query" name:"CalledShowNumber"`
	IsSelfLine           requests.Boolean `position:"Query" name:"IsSelfLine"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DialogId             string           `position:"Query" name:"DialogId"`
	ScheduleTime         requests.Integer `position:"Query" name:"ScheduleTime"`
	CorpName             string           `position:"Query" name:"CorpName"`
	ScheduleCall         requests.Boolean `position:"Query" name:"ScheduleCall"`
}

// BatchRobotSmartCallResponse is the response struct for api BatchRobotSmartCall
type BatchRobotSmartCallResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateBatchRobotSmartCallRequest creates a request to invoke BatchRobotSmartCall API
func CreateBatchRobotSmartCallRequest() (request *BatchRobotSmartCallRequest) {
	request = &BatchRobotSmartCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "BatchRobotSmartCall", "dyvms", "openAPI")
	return
}

// CreateBatchRobotSmartCallResponse creates a response to parse from BatchRobotSmartCall response
func CreateBatchRobotSmartCallResponse() (response *BatchRobotSmartCallResponse) {
	response = &BatchRobotSmartCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
