package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindNumberAndVoipId invokes the dyvmsapi.BindNumberAndVoipId API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/bindnumberandvoipid.html
func (client *Client) BindNumberAndVoipId(request *BindNumberAndVoipIdRequest) (response *BindNumberAndVoipIdResponse, err error) {
	response = CreateBindNumberAndVoipIdResponse()
	err = client.DoAction(request, response)
	return
}

// BindNumberAndVoipIdWithChan invokes the dyvmsapi.BindNumberAndVoipId API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/bindnumberandvoipid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindNumberAndVoipIdWithChan(request *BindNumberAndVoipIdRequest) (<-chan *BindNumberAndVoipIdResponse, <-chan error) {
	responseChan := make(chan *BindNumberAndVoipIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindNumberAndVoipId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindNumberAndVoipIdWithCallback invokes the dyvmsapi.BindNumberAndVoipId API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/bindnumberandvoipid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindNumberAndVoipIdWithCallback(request *BindNumberAndVoipIdRequest, callback func(response *BindNumberAndVoipIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindNumberAndVoipIdResponse
		var err error
		defer close(result)
		response, err = client.BindNumberAndVoipId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindNumberAndVoipIdRequest is the request struct for api BindNumberAndVoipId
type BindNumberAndVoipIdRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VoipId               string           `position:"Query" name:"VoipId"`
}

// BindNumberAndVoipIdResponse is the response struct for api BindNumberAndVoipId
type BindNumberAndVoipIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Module    string `json:"Module" xml:"Module"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateBindNumberAndVoipIdRequest creates a request to invoke BindNumberAndVoipId API
func CreateBindNumberAndVoipIdRequest() (request *BindNumberAndVoipIdRequest) {
	request = &BindNumberAndVoipIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "BindNumberAndVoipId", "dyvms", "openAPI")
	return
}

// CreateBindNumberAndVoipIdResponse creates a response to parse from BindNumberAndVoipId response
func CreateBindNumberAndVoipIdResponse() (response *BindNumberAndVoipIdResponse) {
	response = &BindNumberAndVoipIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
