package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelOrderRobotTask invokes the dyvmsapi.CancelOrderRobotTask API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/cancelorderrobottask.html
func (client *Client) CancelOrderRobotTask(request *CancelOrderRobotTaskRequest) (response *CancelOrderRobotTaskResponse, err error) {
	response = CreateCancelOrderRobotTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CancelOrderRobotTaskWithChan invokes the dyvmsapi.CancelOrderRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/cancelorderrobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelOrderRobotTaskWithChan(request *CancelOrderRobotTaskRequest) (<-chan *CancelOrderRobotTaskResponse, <-chan error) {
	responseChan := make(chan *CancelOrderRobotTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelOrderRobotTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelOrderRobotTaskWithCallback invokes the dyvmsapi.CancelOrderRobotTask API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/cancelorderrobottask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelOrderRobotTaskWithCallback(request *CancelOrderRobotTaskRequest, callback func(response *CancelOrderRobotTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelOrderRobotTaskResponse
		var err error
		defer close(result)
		response, err = client.CancelOrderRobotTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelOrderRobotTaskRequest is the request struct for api CancelOrderRobotTask
type CancelOrderRobotTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
}

// CancelOrderRobotTaskResponse is the response struct for api CancelOrderRobotTask
type CancelOrderRobotTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCancelOrderRobotTaskRequest creates a request to invoke CancelOrderRobotTask API
func CreateCancelOrderRobotTaskRequest() (request *CancelOrderRobotTaskRequest) {
	request = &CancelOrderRobotTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "CancelOrderRobotTask", "dyvms", "openAPI")
	return
}

// CreateCancelOrderRobotTaskResponse creates a response to parse from CancelOrderRobotTask response
func CreateCancelOrderRobotTaskResponse() (response *CancelOrderRobotTaskResponse) {
	response = &CancelOrderRobotTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
